package com.example.hello.android.viewflipper_hello;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ViewFlipper;

public class MainActivity extends Activity implements OnClickListener
{

	private ViewFlipper viewFlipper;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		viewFlipper = (ViewFlipper) findViewById(R.id.viewflipper);
		viewFlipper.setFlipInterval(1000);

		Button nextButton = (Button) findViewById(R.id.next_button);
		Button prevButton = (Button) findViewById(R.id.prev_button);
		nextButton.setOnClickListener(this);
		prevButton.setOnClickListener(this);

	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.next_button:
				viewFlipper.showNext();
				break;
			case R.id.prev_button:
				viewFlipper.showPrevious();
				break;
		}
	}
}
