package kisscelltopng.kiss.types;

import java.io.Serializable;

/**
 * KiSSパレット情報.<br>
 * @author seraphy
 */
public class KiSSPalette implements Serializable {

	/**
	 * シリアライズバージョン
	 */
	private static final long serialVersionUID = -8607552080446070122L;

	/**
	 * パレット名.<br>
	 */
	private String name = "KiSSPalette@" + Integer.toHexString(System.identityHashCode(this));
	
	/**
	 * １色当たりのビット数 ( 12 / 24 )
	 */
	private int bitsPerColor;
	
	/**
	 * １パレット組内の色数 ( 1 ... 256 )
	 */
	private int numOfColors; 
	
	/**
	 * 全パレット組数 ( 1 ~ 10 )
	 */
	private int numOfPaletteGroups;

	/**
	 * パレット
	 */
	private int palettes[][];
	
	
	public KiSSPalette(int bitsPerColor, int numOfColors, int numOfPaletteGroups) {
		this.bitsPerColor = bitsPerColor;
		this.numOfColors = numOfColors;
		this.numOfPaletteGroups = numOfPaletteGroups;
		
		palettes = new int[numOfPaletteGroups][];
		for (int idx = 0; idx < palettes.length; idx++) {
			palettes[idx] = new int[numOfColors];
		}
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getName() {
		return name;
	}
	
	public int getBitsPerColor() {
		return bitsPerColor;
	}
	
	public int getNumOfColors() {
		return numOfColors;
	}
	
	public int getNumOfPaletteGroups() {
		return numOfPaletteGroups;
	}

	public int[] getPaletteGroup(int paletteGroup) {
		if (paletteGroup < 0 || paletteGroup >= palettes.length) {
			// If the number of palette groups is less than 10,
			// colors of the remaining palette groups will be copied from Group 0.
			return palettes[0];
		}
		return palettes[paletteGroup];
	}
	
	@Override
	public String toString() {
		return name;
	}
}
