package kisscelltopng.logic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import kisscelltopng.ui.model.CellsTableItem;
import kisscelltopng.ui.model.CellsTablePaneModel;

/**
 * アーカイブファイルを読み込み、別の形式のファイルとして保存・変換するためのコンバータのインターフェイス.<br>
 * @author seraphy
 */
public interface DataConverter {

	/**
	 * ファイルを読み込む.<br>
	 * @param file
	 * @throws IOException
	 */
	void load(File file) throws IOException;
	
	/**
	 * ファイルをリリースする.<br>
	 * セルテーブルのモデルがnullでない場合は、モデルもクリアされる.<br>
	 * @param model セルテーブルのモデル、null可
	 * @throws IOException 失敗
	 */
	void release(CellsTablePaneModel model) throws IOException;
	
	/**
	 * ファイルの内容を、セルテーブルの表示用モデルに設定する.<br>
	 * @param model セルテーブルのモデル
	 * @throws IOException 失敗
	 */
	void updateCellsTablePaneModel(CellsTablePaneModel model) throws IOException;
	
	/**
	 * セルテーブルのアイテムを指定し、そのアイテムの表示画像を取得する.<br>
	 * @param item セルテーブルのアイテム
	 * @return 表示画像
	 */
	BufferedImage getImage(CellsTableItem item) throws IOException;
	
	/**
	 * 選択されているセルをフォルダに出力する.<br>
	 * パレットとパレットグループの指定、およびサブフォルダの指定があれば、それに従う.<br>
	 * @param destDir 出力先ディレクトリ
	 * @param model モデル
	 * @throws IOException 失敗
	 */
	void save(File destDir, CellsTablePaneModel model) throws IOException;
	
}
