package kisscelltopng.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JPanel;

import kisscelltopng.ui.model.CellViewPanelModel;

public class CellViewPanel extends JPanel implements PropertyChangeListener {
	private static final long serialVersionUID = 1L;

	private CellViewPanelModel model;
	
	public CellViewPanel() {
		this(new CellViewPanelModel());
	}
	
	public CellViewPanel(CellViewPanelModel model) {
		setModel(model);
		setPreferredSize(new Dimension(300, 300));
	}
	
	public final void setModel(CellViewPanelModel model) {
		if (model == null) {
			throw new IllegalArgumentException();
		}
		if (this.model != null) {
			this.model.removePropertyChangeListener(this);
		}
		this.model = model;
		this.model.addPropertyChangeListener(this);
	}
	
	public CellViewPanelModel getModel() {
		return model;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		repaint();
	}
	
	@Override
	protected void paintComponent(Graphics g0) {
		super.paintComponent(g0);
		Graphics2D g = (Graphics2D) g0;
		
		BufferedImage img = getModel().getImg();
		if (img == null) {
			return;
		}
		int width = img.getWidth();
		int height = img.getHeight();
		g.drawImage(img, 0, 0, width, height, null);
	}
	
}