package kisscelltopng.ui.model;

import java.awt.Dimension;
import java.io.Serializable;

import kisscelltopng.kiss.types.KiSSPalette;

public class CellsTableItem implements Serializable, Comparable<CellsTableItem> {

	private static final long serialVersionUID = -2752447694660738421L;

	private boolean selected;
	
	private boolean indexedColor;
	
	private String fileName = "";

	private String cellName = "";
	
	private Dimension size = new Dimension(0, 0);
	
	private KiSSPalette palette;
	
	private int paletteGroup;
	
	private String outdir = "";
	
	public int compareTo(CellsTableItem o) {
		// ファイル名により一意になるため、ファイル名の比較のみでOK.
		return fileName.compareTo(o.fileName);
	}
	
	public boolean isSelected() {
		return selected;
	}
	
	public void setSelected(boolean selected) {
		this.selected = selected;
	}
	
	public boolean isIndexedColor() {
		return indexedColor;
	}
	
	public void setIndexedColor(boolean indexedColor) {
		this.indexedColor = indexedColor;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		if (fileName == null) {
			fileName = "";
		}
		this.fileName = fileName;
	}

	public String getCellName() {
		return cellName;
	}

	public void setCellName(String cellName) {
		if (cellName == null) {
			cellName = "";
		}
		this.cellName = cellName;
	}

	public Dimension getSize() {
		return (Dimension) size.clone();
	}

	public void setSize(Dimension size) {
		if (size == null) {
			size = new Dimension(0, 0);
		}
		this.size = (Dimension) size.clone();
	}

	public KiSSPalette getPalette() {
		return palette;
	}

	public void setPalette(KiSSPalette palette) {
		this.palette = palette;
	}

	public int getPaletteGroup() {
		return paletteGroup;
	}

	public void setPaletteGroup(int paletteGroup) {
		this.paletteGroup = paletteGroup;
	}

	public String getOutdir() {
		return outdir;
	}

	public void setOutdir(String outdir) {
		if (outdir == null) {
			outdir = "";
		}
		this.outdir = outdir;
	}
}