package kisscelltopng.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;

import kisscelltopng.kiss.types.KiSSPalette;

public class PalettePanelModel implements Serializable {

	private static final long serialVersionUID = -4938211662383604744L;
	
	private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	private File paletteFile;
	
	private KiSSPalette palette;

	public void setPalette(KiSSPalette palette) {
		KiSSPalette old = this.palette;
		this.palette = palette;
		propertyChangeSupport.firePropertyChange("palette", old, palette);
	}
	
	public void setPaletteFile(File paletteFile) {
		File old = this.paletteFile;
		this.paletteFile = paletteFile;
		propertyChangeSupport.firePropertyChange("paletteFile", old, paletteFile);
	}
	
	public KiSSPalette getPalette() {
		return palette;
	}
	
	public File getPaletteFile() {
		return paletteFile;
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}
}