/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.entity;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NoSuchElementException;
import java.util.Set;

/**
 *
 * @author seraphy
 */
public class FilteredRowMap extends AbstractMap<RowKey, RowValues> {

    private Map<RowKey, RowValues> dataMap;
    
    private RowFilter rowFilter;
    
    public FilteredRowMap(Map<RowKey, RowValues> dataMap) {
        this(dataMap, DisplayMode.ALL);
    }
    
    public FilteredRowMap(Map<RowKey, RowValues> dataMap, RowFilter rowFilter) {
        if (dataMap == null || rowFilter == null) {
            throw new IllegalArgumentException();
        }
        this.dataMap = dataMap;
        this.rowFilter = rowFilter;
    }

    public void setRowFilter(RowFilter rowFilter) {
        if (rowFilter == null) {
            throw new IllegalArgumentException();
        }
        this.rowFilter = rowFilter;
    }
    
    public RowFilter getRowFilter() {
        return rowFilter;
    }
    
    private static int ref = 0;

    @Override
    public Set<Entry<RowKey, RowValues>> entrySet() {
        final Set<Entry<RowKey, RowValues>> set = dataMap.entrySet();
        final RowFilter filter = this.rowFilter;
        return new AbstractSet<Entry<RowKey, RowValues>>() {
            @Override
            public Iterator<Entry<RowKey, RowValues>> iterator() {
                ref++;
                final Iterator<Entry<RowKey, RowValues>> ite = set.iterator();
                return new Iterator<Entry<RowKey, RowValues>>() {
                    
                    private Entry<RowKey, RowValues> nextEntry;
                    
                    private void fetch() {
                        nextEntry = null;
                        while (ite.hasNext()) {
                            Entry<RowKey, RowValues> entry = ite.next();
                            if (filter.isAcceptable(entry.getValue())) {
                                nextEntry = entry;
                                return;
                            }
                        }
                    }
                    
                    @Override
                    public boolean hasNext() {
                        if (nextEntry == null) {
                            fetch();
                        }
                        return nextEntry != null;
                    }

                    @Override
                    public Entry<RowKey, RowValues> next() {
                        if (nextEntry == null) {
                            fetch();
                        }
                        if (nextEntry == null) {
                            throw new NoSuchElementException();
                        }
                        Entry<RowKey, RowValues> entry = nextEntry;
                        this.nextEntry = null;
                        return entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public int size() {
                int cnt = 0;
                Iterator<Entry<RowKey, RowValues>> ite = iterator();
                while (ite.hasNext()) {
                    ite.next();
                    cnt++;
                }
                return cnt;
            }
        };
    }
    
    public static int getRef() {
        return ref;
    }
}
