/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.entity;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

/**
 * キーマッチングのタイプ.
 * @author seraphy
 */
public enum KeyMatcher {

    TEXT(){
        @Override
        public int compare(String k1, String k2) {
            k1 = getNormalize(k1);
            k2 = getNormalize(k2);

            int ret = k1.compareTo(k2);
            
            return ret;
        }
        
        @Override
        public String getNormalize(String org) {
            return org == null ? "" : org;
        }
        
        @Override
        public int hashCode(String org) {
            return getNormalize(org).hashCode();
        }
    },
    TEXT_IGNORECASE() {
        @Override
        public int compare(String k1, String k2) {
            k1 = getNormalize(k1);
            k2 = getNormalize(k2);

            int ret = k1.compareTo(k2);

            return ret;
        }

        @Override
        public String getNormalize(String org) {
            return org == null ? "" : org.toLowerCase();
        }

        @Override
        public int hashCode(String org) {
            return getNormalize(org).hashCode();
        }
    },
    NUMERIC() {
        @Override
        public int compare(String k1, String k2) {
            k1 = getNormalize(k1);
            k2 = getNormalize(k2);
            
            boolean b1 = StringUtils.isNumeric(k1);
            boolean b2 = StringUtils.isNumeric(k2);
            
            int ret;
            if (b1 && b2) {
                // 双方とも数値
                BigDecimal n1 = new BigDecimal(k1);
                BigDecimal n2 = new BigDecimal(k2);
                ret = n1.compareTo(n2);
            
            } else if (!b1 && !b2) {
                // 双方とも数値でない
                // 長さをそろえる
                int l1 = k1.length();
                int l2 = k2.length();
                int len = Math.max(l1, l2);
                k1 = spaceWith(len - l1, k1);
                k2 = spaceWith(len - l2, k2);
                ret = k1.compareTo(k2);
            
            } else if (b1) {
                // k1のみ数値
                ret = -1;

            } else {
                // k2のみ数値
                ret = 1;
            }

            return ret;
        }
        
        public String spaceWith(int space, String r) {
            StringBuilder buf = new StringBuilder();
            while (space > 0) {
                buf.append(' ');
                space--;
            }
            if (r != null) {
                buf.append(r);
            }
            return buf.toString();
        }

        @Override
        public String getNormalize(String org) {
            return org == null ? "" : org.toLowerCase().trim();
        }

        @Override
        public int hashCode(String org) {
            String val = getNormalize(org);
            if (StringUtils.isNumeric(val)) {
                return new BigDecimal(val).hashCode();
            }
            return val.hashCode();
        }
    },;

    public abstract int compare(String k1, String k2);
    
    public abstract String getNormalize(String org);
    
    public abstract int hashCode(String org);
}
