/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * ファイルに対してドキュメントの保存と復元を行うクラス.<br>
 * @author seraphy
 */
public class FileDocArchive implements DocArchive {
    
    /**
     * ロードまたはセーブするファイル
     */
    private File file;
    
    
    /**
     * 書き込みデータ形式.
     */
    private DocArchiveStrategy strategy = new ProtocolBufferesDocArchiveStrategy();
    

    /**
     * ファイルを指定して構築する
     * @param file ファイル
     */
    public FileDocArchive(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }
    
    /**
     * ファイルに保存する
     * @param doc ドキュメント
     * @throws IOException 失敗
     */
    @Override
    public void save(TextKeyMatcherDoc doc) throws IOException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }

        OutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            strategy.write(fos, doc);
            
        } finally {
            fos.close();
        }
    }

    /**
     * ファイルから復元する.
     * @return 復元されたドキュメント
     * @throws IOException 
     */
    @Override
    public TextKeyMatcherDoc load() throws IOException {
        InputStream fis = new BufferedInputStream(new FileInputStream(file));
        try {
            return strategy.load(fis);
            
        } finally {
            fis.close();
        }
    }
    

}
