/*
 * CAN/LIN/UART/PORT Checker for RL78/F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ NbNhCo ]
 */

#include "common.h"
#include "iodefine.h"
#include "cpu.h"

/*
 * SFRݒl(PER0WX^)
 */
#define RL78F_PER0_DISABLE		((u1)(0x00))
									/* PER0Ӌ@\~ */

/*
 * SFRݒl(PER1WX^)
 */
#define RL78F_PER1_DISABLE		((u1)(0x00))
									/* PER1Ӌ@\~ */

/*
 * SFRݒl(PER2WX^)
 */
#define RL78F_PER2_DISABLE		((u1)(0x00))
									/* PER2Ӌ@\~ */

/*
 * SFRݒl(CMCWX^)
 */
#define RL78F_CMC_OSCSEL		((u1)(0x40))
									/* X1U[h */

/*
 * SFRݒl(OSTSWX^)
 */
#define RL78F_OSTS_OSTS7		((u1)(0x05))
									/* U莞:8.15ms(X1=4MHz) */

/*
 * SFRݒl(CSCWX^)
 */
#define RL78F_CSC_XTSTOP		((u1)(0x40))
									/* XT1UH~ */

/*
 * SFRݒl(OSTCWX^)
 */
#define RL78F_OSTC_OSTS7		((u1)(0xfc))
									/* U莞ԃJE^:2^15/fX */

/*
 * SFRݒl(CKCWX^)
 */
#define RL78F_CKC_MCM0			((u1)(0x10))
									/* CEVXeENbNɍVXeENbNI */
#define RL78F_CKC_MCS			((u1)(0x20))
									/* CPU/Ӄn[hEFAENbNX1UNbN */

/*
 * SFRݒl(PLLCTLWX^)
 */
#define RL78F_PLLCTL_PLLON		((u1)(0x01))
									/* PLLUJn */
#define RL78F_PLLCTL_PLLMUL		((u1)(0x02))
									/* PLL16{2((4MHz*16)/2 = 32MHz) */
#define RL78F_PLLCTL_SELPLL		((u1)(0x04))
									/* CNbNƂPLLNbNI */
#define RL78F_PLLCTL_LCKSEL		((u1)(0x80))
									/* bNAbv҂JE^Ƃ512/fMAINI */

/*
 * SFRݒl(PLLSTSWX^)
 */
#define RL78F_PLLSTS_SELPLLS	((u1)(0x08))
									/* CNbNƂPLLNbNI */
#define RL78F_PLLSTS_LOCK		((u1)(0x80))
									/* PLLbN */

/*
 * SFRݒl(MDIVWX^)
 */
#define RL78F_MDIV_FMP			((u1)(0x00))
									/* fMPNbN𕪎Ȃ */

/*
 * NbN
 * Ӌ@\~
 */
static void clock_per_disable(void)
{
	/* ӃCl[uEWX^0 */
	PER0 = RL78F_PER0_DISABLE;

	/* ӃCl[uEWX^1 */
	PER1 = RL78F_PER1_DISABLE;

	/* ӃCl[uEWX^2 */
	PER2 = RL78F_PER2_DISABLE;
}

/*
 * NbN
 * X1NbNUJn
 */
static void clock_x1_start(void)
{
	u1 ostc_sts;
	u1 ckc_sts;

	/* X1/P121[qX1U[hɑI */
	CMC = RL78F_CMC_OSCSEL;

	/* X1UH̔U莞Ԃw */
	OSTS = RL78F_OSTS_OSTS7;

	/* X1UHJn(XT1UH͒~) */
	CSC = RL78F_CSC_XTSTOP;

	/* X1UH̔U莞Ԃ܂ő҂ */
	ostc_sts = OSTC;
	while (RL78F_OSTC_OSTS7 != ostc_sts)
	{
		ostc_sts = OSTC;
	}

	/* X1UNbNCPU/Ӌ@NbNƂĐݒ(4MHz) */
	CKC = RL78F_CKC_MCM0;

	/* X1UNbNCPU/Ӌ@NbNɐݒ肳܂ő҂ */
	ckc_sts = CKC;
	while (0 == (ckc_sts & RL78F_CKC_MCS))
	{
		ckc_sts = CKC;
	}
}

/*
 * NbN
 * PLLNbNUJn
 *
 * X1NbN̔UJnO
 */
static void clock_pll_start(void)
{
	u1 loop;
	u1 pll_sts;

	/* PLL16{2ɐݒBbNAbv҂JE^512/fMAIN */
	PLLCTL = (RL78F_PLLCTL_PLLMUL | RL78F_PLLCTL_LCKSEL);

	/* 1us̃[vBRL78/F13,F14͍ŏ31.25nsŖߎs\Ȃ̂ŁA32̃[v\ */
	for (loop=0; loop < 32; loop++)
	{
		/* NOP */
		cpu_nop();
	}

	/* PLLUJn */
	PLLCTL = (RL78F_PLLCTL_PLLMUL | RL78F_PLLCTL_LCKSEL | RL78F_PLLCTL_PLLON);

	/* PLLbNԂɂȂ܂ő҂ */
	pll_sts = PLLSTS;
	while (0 == (pll_sts & RL78F_PLLSTS_LOCK))
	{
		pll_sts = PLLSTS;
	}

	/* fMP͕Ȃ(IvVoCgōOSC32MHzɐݒ肳Ă邱) */
	MDIV = RL78F_MDIV_FMP;

	/* CNbNƂPLNbNI */
	PLLCTL = (RL78F_PLLCTL_PLLMUL | RL78F_PLLCTL_LCKSEL | RL78F_PLLCTL_PLLON | RL78F_PLLCTL_SELPLL);

	/* PLLNbNI܂ő҂ */
	pll_sts = PLLSTS;
	while (0 == (pll_sts & RL78F_PLLSTS_SELPLLS))
	{
		pll_sts = PLLSTS;
	}
}

/*
 * NbN
 * 
 */
void clock_init(void)
{
	/* PERӋ@\~ */
	clock_per_disable();

	/* X1NbN̔UJn(4MHz) */
	clock_x1_start();

	/* PLLNbN̔UJn(32MHz) */
	clock_pll_start();
}
