
#include <cassert>
#include "cm_condition.h"

namespace cm {

Condition::Condition()
    : cond_()
{
    int ret = pthread_cond_init(&cond_, NULL);
    assert(ret == 0);
}

Condition::~Condition()
{
    int ret = pthread_cond_destroy(&cond_);
    assert(ret == 0);
}

void Condition::wait(const Mutex& mutex)
{
    int ret = pthread_cond_wait(&cond_, &mutex.mutex_);
    assert(ret == 0);
}

void Condition::broadcast()
{
    int ret = pthread_cond_broadcast(&cond_);
    assert(ret == 0);
}

} // namespace cm

