
#include <errno.h>
#include <cassert>

#include "mt_shim_clear_memory.h"
#include "cm_vector_socket.h"

namespace cm {

VectorSocket::VectorSocket(int fd)
    : fd_(fd)
{}

bool VectorSocket::writev(size_t& bytes_written, const IOVectorBase& vector, size_t skip_bytes)
{
    assert(fd_ >= 0);

    struct iovec iovector[MAX_IOVEC_COUNT];

    mt::clearMemory(iovector);

    size_t count = vector.setToVector(iovector, skip_bytes);

    ssize_t ret = ::writev(fd_, iovector, count);

    if (ret < 0) {
        if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
            return this->writev(bytes_written, vector, skip_bytes);
        }
        else if (errno == EPIPE) {
            return false;
        }
        assert(false);  
        return false;
    }

    bytes_written = static_cast<size_t>(ret);
    return true;
}

int VectorSocket::release()
{
    int fd_to_return = fd_;
    fd_ = -1;
    return fd_to_return;
}

} // namespace cm
