
#include "gtest/gtest.h"
#include "cm_thread.h"
#include "cm_condition.h"

namespace cm {

namespace {

struct TestThreadArg
{
    TestThreadArg()
        : mutex(), cond(), value(false)
    {
    }


    Mutex mutex;
    Condition cond;
    bool value;
private:
    // Non-copyable
    TestThreadArg(const TestThreadArg& rhs);
    TestThreadArg& operator=(const TestThreadArg& rhs);
};

class TestThread
{
public:
    TestThread(TestThreadArg* arg_ptr)
    {
        Mutex::Lock lock(arg_ptr->mutex);
        arg_ptr->value = true;
        arg_ptr->cond.broadcast();
    }

    void run()
    {
    }
};

TEST(CmConditionTest, wait_and_broadcast_operation)
{

    for (uint i = 0; i < 50; ++i) {
        Thread<TestThread, TestThreadArg> thread("test_thread");

        TestThreadArg arg;

        {
            Mutex::Lock lock(arg.mutex);
            thread.create(&arg);
            if (!arg.value) {
                arg.cond.wait(arg.mutex);
            }
            EXPECT_EQ(arg.value, true);
        }

        thread.join();
    }
}

} // namespace

} // namespace cm
