
#ifndef INC_CM_SOCKET_IF_H_
#define INC_CM_SOCKET_IF_H_

#include "mt_auto_ptr.h"

namespace cm {

class SocketIf
{
public:
    virtual ~SocketIf()
    {}

    virtual bool read(size_t& bytes_read, void* buf, size_t size_to_read) = 0;
    virtual bool write(size_t& bytes_written, const void* buf, size_t size_to_write) = 0;

    virtual int getFD() const = 0;

    mt::AutoPtr<SocketIf> clone(int fd) const
    {
        return mt::AutoPtr<SocketIf>(this->doClone(fd));
    }

    virtual int release() = 0;

protected:
    virtual SocketIf* doClone(int fd) const = 0;
    
};

inline int getFD(SocketIf& event_type)
{
    return event_type.getFD();
}

} // namespace cm

#endif // INC_CM_SOCKET_IF_H_
