
#ifndef INC_CM_OPTION_H_
#define INC_CM_OPTION_H_

#include <vector>

#include "types.h"
#include "mt_typelist.h"
#include "mt_mpl.h"
#include "mt_sfinae.h"
#include "mt_type_identity.h"
#include "mt_unuse.h"
#include "mt_tuple.h"
#include "mt_range.h"

namespace mt {

// what kind of syntax we would like to support?
/*

The following typical config text will not allow nesting
[indent1]
key1 = value1;
key2 = value2;
key1 = value3;  // This will override the orignally parsed key1.

[indent2]
key1 = value1
key2 = value2;
key3 = value3;

The following typical XML based configuration file will allow nesting

<Indent1>
<Key1 value=value1/>
<Key2 value=value2/>
<Key3>
    <Nest value=value3_1/>
    <Nest value=value3_2/>
</Key3>
</Indent1>
...


const OptionBase& option = Options<TL>();

option.parseViaCommandLineArg(argc, argv);
option.parseViaFile(const char* path);

option.isSetByKey(key);
option.isSetByKey(ElementKeyChain(catetogry)(key));
option.getStringByKey(ElementKeyChain(category)(key));
option.getValueByKey(ElementKeyChain(cat)(key));

*/

template <typename TL>
struct HasElementType
{
    static const bool value = false;
};

template <typename T, typename U>
struct HasElementType< mt::Typelist<T, U> >
{
    template <typename X>
    static mt::YesTypeWith2TemplateParam<X, typename X::Head, typename X::Head::ElementType> test(const X*);

    template <typename X>
    static mt::NoType test(...);

    static const bool value = sizeof(test<mt::Typelist<T, U> >(0)) != sizeof(mt::NoType);
};

template <typename TL, typename V, bool cond, typename ResultType>
struct GetMatchedTypesImpl;

template <typename T, typename U, typename V, typename ResultType>
struct GetMatchedTypesImpl<mt::Typelist<T, U>, V, true, ResultType>
{
    typedef typename mt::Select<mt::IsIdentical<typename T::ElementType, V>::value,
                       typename GetMatchedTypesImpl<U, V, HasElementType<U>::value, typename mt::Append<ResultType, T>::Result >::Result,
                       typename GetMatchedTypesImpl<U, V, HasElementType<U>::value, ResultType>::Result
                      >::Result Result;
};

template <typename T, typename U, typename V, typename ResultType>
struct GetMatchedTypesImpl<mt::Typelist<T, U>, V, false, ResultType>
{
    typedef typename GetMatchedTypesImpl<U, V, HasElementType<U>::value, ResultType>::Result Result;
};

template <typename V, bool cond, typename ResultType>
struct GetMatchedTypesImpl<mt::NullType, V, cond, ResultType>
{
    typedef ResultType Result;
};

template <typename TL, typename V>
struct GetMatchedTypes
{
    typedef typename GetMatchedTypesImpl<TL, V, HasElementType<TL>::value, mt::NullType>::Result Result;
};

template <size_t N>
struct Uint2Type : public mt::StaticValue<size_t, N>
{
};

struct OptionHelp
{
    static const char* getOptionKey() { return "h"; }
    static const char* getVOptionKey() { return "help"; }

    typedef mt::NullType OptionType;
    typedef Uint2Type<0> ArgNumber;
    typedef bool ReturnType;

    OptionHelp()
    {}

    bool operator()(ReturnType& value)
    {
        value = true;
        return true;
    }
};

template <typename T>
struct HasArgNumberType
{
    template <typename X>
    static mt::YesTypeWith1TemplateParam<X, typename X::ArgNumber> test(const X*);

    template <typename X>
    static mt::NoType test(...);

    static const bool value = sizeof(test<T>(0)) != sizeof(mt::NoType);
};

#pragma GCC diagnostic ignored "-Weffc++"
class Options
{
public:
    Options()
        : arguments_()
    {}

    virtual ~Options()
    {}

    void setCommandLineArgs(int argc, const char* argv[])
    {
        assert(argc >= 0);

        arguments_.clear();
        for (ulong i = 0; i < static_cast<ulong>(argc); ++i) {
            arguments_.push_back(argv[i]);
        }
    }

    template <typename OptElm, typename Arg>
    bool getParam(Arg& arg)
    {
        return doGetParam1<OptElm>(arg, 0);
    }

    template <typename OptElm, typename Arg1, typename Arg2>
    bool getParam(Arg1& arg1, Arg2& arg2)
    {
        return doGetParam2<OptElm>(arg1, arg2, 0);
    }

protected:
    std::vector<std::string> arguments_;

private:
    template <typename OptElm>
    bool doGetParam1(typename OptElm::ArgType1& arg1,
                     typename mt::EnableIf<HasArgNumberType<OptElm>::value &&
                                           mt::IsIdentical<typename OptElm::ArgNumber, Uint2Type<1u> >::value>
                              ::Result*)
    {
        typedef std::vector<std::string>::const_iterator ConstIteratorType;
        typedef std::string ValueType;

        ConstIteratorType beg_it = mt::cbegin(arguments_), end_it = mt::cend(arguments_);

        for(; beg_it != end_it; ++beg_it) {
            const ValueType& item = *beg_it;
            if ((item == (std::string("-") + OptElm::getOptionKey())) ||
                (item == (std::string("--") + OptElm::getVOptionKey()))) {
                assert((beg_it + 1) != end_it);
                return OptElm()(arg1, *(beg_it + 1));
            }
        }
        return false;
    }

    template <typename OptElm>
    bool doGetParam1(typename OptElm::ArgType1& arg1, ...)
    {
        return false;
    }

    template <typename OptElm>
    bool doGetParam2(typename OptElm::ArgType1& arg1, typename OptElm::ArgType2& arg2,
                     typename mt::EnableIf<HasArgNumberType<OptElm>::value &&
                                           mt::IsIdentical<typename OptElm::ArgNumber, Uint2Type<2u> >::value>
                              ::Result*)
    {
        typedef std::vector<std::string>::const_iterator ConstIteratorType;
        typedef std::string ValueType;

        ConstIteratorType beg_it = mt::cbegin(arguments_), end_it = mt::cend(arguments_);

        for(; beg_it != end_it; ++beg_it) {
            const ValueType& item = *beg_it;
            if ((item == (std::string("-") + OptElm::getOptionKey())) ||
                (item == (std::string("--") + OptElm::getVOptionKey()))) {
                assert((beg_it + 2) != end_it);
                return OptElm()(arg1, arg2, *(beg_it + 1), *(beg_it + 2));
            }
        }
        return false;
    }

    template <typename OptElm>
    bool doGetParam2(typename OptElm::Head::ArgType1& arg1, typename OptElm::Head::ArgType2& arg2, ...)
    {
        return false;
    }

};
#pragma GCC diagnostic warning "-Weffc++"

} // namespace mt

#endif // INC_CM_OPTION_H_

