
#ifndef INC_MT_RANGE_H_
#define INC_MT_RANGE_H_

#include "mt_mpl.h"
#include "mt_iterator_type_detector.h"

namespace mt {

template <typename T>
struct GetIteratorType
{
    typedef typename T::iterator Result;
};

template <typename ArrayType, size_t N>
struct GetIteratorType<ArrayType[N]>
{
    typedef ArrayType* Result;
};

template <typename T>
struct GetValueType
{
    typedef typename T::value_type Result;
};

template <typename ArrayType, size_t N>
struct GetValueType<ArrayType[N]>
{
    typedef ArrayType Result;
};

template <typename T>
struct GetConstIteratorType
{
    typedef typename T::const_iterator Result;
};

template <typename ArrayType, size_t N>
struct GetConstIteratorType<ArrayType[N]>
{
    typedef const ArrayType* Result;
};

template <typename Container>
inline typename GetIteratorType<Container>::Result begin(Container& cont,
                                          typename EnableIf<HasIteratorType<Container>::value>::Result* = 0)
{
    return cont.begin();
}

template <typename ArrayType, size_t Size>
inline typename GetIteratorType<ArrayType[Size]>::Result begin(ArrayType (&array)[Size])
{
    return &array[0];
}

template <typename Container>
inline typename GetConstIteratorType<Container>::Result cbegin(const Container& cont,
                                                 typename EnableIf<HasConstIteratorType<Container>::value>::Result* = 0)
{
    return cont.begin();
}

template <typename ArrayType, size_t Size>
inline typename GetConstIteratorType<ArrayType[Size]>::Result cbegin(const ArrayType (&array)[Size])
{
    return &array[0];
}

template <typename Container>
inline typename GetIteratorType<Container>::Result end(Container& cont,
                                        typename EnableIf<HasIteratorType<Container>::value>::Result* = 0)
{
    return cont.end();
}

template <typename ArrayType, size_t Size>
inline typename GetIteratorType<ArrayType[Size]>::Result end(ArrayType (&array)[Size])
{
    return &array[Size];
}

template <typename Container>
inline typename GetConstIteratorType<Container>::Result cend(const Container& cont,
                                              typename EnableIf<HasConstIteratorType<Container>::value>::Result* = 0)
{
    return cont.end();
}

template <typename ArrayType, size_t Size>
inline typename GetConstIteratorType<ArrayType[Size]>::Result cend(const ArrayType (&array)[Size])
{
    return &array[Size];
}

} // namespace mt

#endif // INC_MT_RANGE_H_

