
#ifndef INC_MT_SHIM_CLEAR_MEMORY_H_
#define INC_MT_SHIM_CLEAR_MEMORY_H_

#include <cstring>
#include <string>

#include "mt_mpl.h"
#include "mt_sfinae.h"

namespace mt {

template <typename T>
struct HasIteratorTypeAndClearMethod
{
    template <typename X>
    static YesTypeWith1TemplateParamAndNonConstMemberMethodNoArg<X, typename X::iterator, void, &X::clear> test(X*);

    template <typename X>
    static NoType test(...);

    static const bool value = sizeof(test<T>(0)) != sizeof(NoType);
};

template <typename T>
inline void clearMemory(T& obj, typename EnableIf<!HasIteratorTypeAndClearMethod<T>::value>::Result* = 0)
{
    memset(&obj, 0, sizeof(obj));
}

template <typename T, size_t N>
inline void clearMemmory(T (&array)[N], typename EnableIf<!HasIteratorTypeAndClearMethod<T>::value>::Result* = 0)
{
    memset(&array[0], 0, sizeof(array));
}

template <typename CharType, typename Allocator>
inline void clearMemory(std::basic_string<CharType, Allocator>& str)
{
    std::basic_string<CharType, Allocator> str_to_swap;
    str.swap(str_to_swap);
}

template <typename Container>
inline void clearMemory(Container& cont, typename EnableIf<HasIteratorTypeAndClearMethod<Container>::value>::Result* = 0)
{
    cont.clear();
}

} // namespace mt

#endif // INC_MT_SHIM_CLEAR_MEMORY_H_
