autoload -Uz compinit
autoload -Uz vcs_info
autoload history-search-end

compinit

zstyle ':completion:*' completer _expand _complete _correct _approximate
zstyle ':completion:*' max-errors 3 not-numeric
zstyle ':completion:*' list-colors ''
zstyle ':compinstall' filename '~/.zshrc'
zstyle ':vcs_info:*' formats '[%s:%b]'
zstyle ':vcs_info:*' actionformats '[$s:%b|%a]'
zstyle ':vcs_info:(svn):*' branchformat 'r%r'

setopt auto_cd
setopt auto_param_slash
setopt auto_pushd
setopt auto_resume
setopt correct
setopt hist_ignore_dups
setopt ignore_eof
setopt extended_glob
setopt list_packed
setopt magic_equal_subst
setopt nolistbeep
setopt no_flow_control
setopt no_beep
setopt prompt_subst
setopt share_history

zle -N history-beginning-search-backward-end history-search-end
zle -N history-beginning-search-forward-end history-search-end

alias ls="ls --color=auto"
alias ll="ls -al"
alias h="history"
alias j="jobs"
alias -g L="| less"
alias -g G="| grep"

bindkey -e

bindkey "^P" history-beginning-search-backward-end
bindkey "^N" history-beginning-search-forward-end

precmd() {
        echo -ne "\033]0;${USER}@${HOST}: ${PWD}\007"
        psvar=()
        LANG=C vcs_info
        [[ -n "$vcs_info_msg_0_" ]] && psvar[1]="$vcs_info_msg_0_"
}

chpwd() {
        ls
}

PROMPT='%U%n%F{green}@%m%f-%l%u(%j) - %F{cyan}<%D %*>%f : %F{yellow}%d%f %1(v|- %F{green}%1v%f|)
%# '

HISTFILE=~/.zsh_history
HISTSIZE=1000000
SAVEHIST=1000000

export LANG="ja_JP.utf-8"
#export LANG=C
export JAVA_HOME=/usr/lib/jvm/java-6-openjdk
export ANT_HOME=/opt/ant
export EDITOR="emacs"
export PAGER="less"
export EN_PROXY=$http_proxy
export INCLUDE=/usr/src/boost/boost_1_45_0/boost
export PATH=$JAVA_HOME/bin:$ANT_HOME/bin:$PATH

if ( ! test $TMUX ) && ( ! expr $TERM : "^screen" > /dev/null ) && which tmux > /dev/null; then
    if ( tmux has-session ); then
        session=`tmux list-sessions | grep -e '^[0-9].*]$' | head -n 1 | sed -e 's/^\([0-9]\+\).*$/\1/'`
            if [ -n "$session" ]; then
            echo "Attache tmux session $session."
                tmux attach-session -t $session
        else
            echo "Session has been already attached."
            tmux attach
            fi
    else
        echo "Create new tmux session."
        tmux
    fi
fi


export PATH=${PATH}:/opt/gcc451/bin

