#!/usr/bin/env python

import sys, os, re, signal
from libs import term, config

version_number = "$Id: 68591edcf38f664f34545428df08eb8549f5f43c $"

include_path = []

def findheader2(target, rootdir):
    path = None
    for root, dirs, files in os.walk(rootdir):
        if target in files:
            path = os.path.abspath(os.path.join(root, target))
            break
    return path


def findheader(filename):
    pattern = re.compile("^#.*include [<\"].*[>\"]")
    delimiter = re.compile('[<>"]')
    found_flag = False

    print("*target source: " + term.green(filename))

    try:
        f = open(filename, 'r')
    except IOError, (errno, msg):
        print(term.tab(1, term.red("!! cannot open %s" % (filename))))
        print('')
        return

    for line in f.readlines():
        found_flag = False
        global_flag = True
        line = line.strip()
        result = pattern.search(line)
        if result != None:
            x = delimiter.split(line)
            for dir in include_path:
                if found_flag == True:
                    break
                else:
                    path = findheader2(x[1].split('/')[-1], dir)
                    if path != None:
                        print(term.tab(1, term.cyan("o %s found" % (x[1]))))
                        found_flag = True
            if found_flag == False:
                print(term.tab(1, term.purple("x %s is not found." % (x[1]))))
    
    print('')


def sigint(num, frame):
    print('process interrupted.')
    sys.exit(2)


def print_usage():
    print_version()
    print("usage: %s [target]..." % (sys.argv[0]))


def print_version():
    print("hl version %s" % (version_number[5:-2]))


def print_header():
    print('-' * 40)
    print("*Processing " + term.green("%d " % (len(sys.argv) - 1)) + "file(s).")
    print("*header search dirs: ")
    for line in include_path:
        print(term.tab(1, term.green(line)))
    print('-' * 40)
    print('')
    

if __name__ == '__main__':
    signal.signal(signal.SIGINT, sigint)

    if len(sys.argv) == 1:
        print_usage()
        sys.exit(2)

    term.color_mode = True

    include_path = config.get_include_dir()
    print_header()

    for target in sys.argv[1:]:
        findheader(target)
