package framework;

import framework.SceneManager;
import flash.display.Bitmap;
import flash.errors.Error;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;

import framework.GraphicManager;
import framework.SoundManager;
import framework.FontManager;
import framework.FpsView;

/**
 * ゲームのメインとなるクラス。これを継承して使う
 * @author syun
 */
class Application extends Sprite {
    private var m_Bg:BitmapData = null;
    private var m_Rect:Rectangle = null;

    private static var m_ScreenWidth:Int;
    private static var m_ScreenHeight:Int;

    private var m_Fps:FpsView;

    /**
     * サイズを取得
     **/
    public static function Width() {
        return m_ScreenWidth;
    }
    public static function Height() {
        return m_ScreenHeight;
    }

    /**
	 * コンストラクタ
	 */
    public function new() {
        super();
        m_Fps = new FpsView();

        if (stage != null) { initialize(); }
        else { addEventListener(Event.ADDED_TO_STAGE, initialize); }
    }

    /**
	 * 起動時の初期化
	 * @param	e イベント
	 */
    private function initialize(e:Event=null):Void {
        // イベントリスナーに登録
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        create(e);
        addEventListener(Event.ENTER_FRAME, update);

        // ここでフォントのロード
        IToken.s_f.load();
    }

    /**
	 * ゲーム起動時の初期化処理。overrideして実装する
	 */
    public function create(e:Event):Void {
        throw new Error("Application.create()が未実装");
    }

    /**
	 * 更新
	 * @param	e
	 */
    private function update(e:Event):Void {

        m_Fps.update();

        IToken.s_i.beginFrame();
        {
            // シーンの更新
            SceneManager.get().update();

            // シーンの描画
            m_Bg.lock();
            IToken.s_g.clearScreen();
            SceneManager.get().draw();
            m_Fps.draw();
            m_Bg.unlock();
        }
        IToken.s_i.endFrame();

    }

    /**
	 * スクリーンの生成
	 * @param	w 幅
	 * @param	h 高さ
	 */
    public function createScreen(w:Int, h:Int):Void {
        if (m_Bg != null) {
            throw new Error("複数回のcreateScreenは禁止です");
        }

        // スクリーンの生成
        m_ScreenWidth = w;
        m_ScreenHeight = h;
        m_Bg = new BitmapData(w, h, false);
        addChild(new Bitmap(m_Bg));
        m_Rect = new Rectangle(0, 0, w, h);

        IToken.s_g = new GraphicManager(m_Bg, graphics);
        IToken.s_i = InputManager.getInstance();
        IToken.s_i.init(stage);
        IToken.s_m = new SoundManager();
        IToken.s_f = new FontManager(IToken.s_g);

    }
}

