package framework;

import framework.util.Debug;
import flash.display.Stage;
import flash.events.MouseEvent;
import flash.events.KeyboardEvent;
import flash.errors.Error;

import framework.Mouse;
import framework.Keyboard;
import framework.GamePad;

/**
 * 入力管理
 * @author syun
 */
class InputManager {

    private static var m_Instance:InputManager = null;
    private var m_bInit:Bool = false;
    private var m_Mouse:Mouse;
    private var m_Keyboard:Keyboard;
    private var m_Pad:GamePad;

    public static inline var KEYCODE_LEFTARROW:Int = 37;
    public static inline var KEYCODE_UPARROW:Int = 38;
    public static inline var KEYCODE_RIGHTARROW:Int = 39;
    public static inline var KEYCODE_DOWNARROW:Int = 40;
    public static inline var KEYCODE_Z:Int = 90;
    public static inline var KEYCODE_X:Int = 88;
    public static inline var KEYCODE_C:Int = 67;
    public static inline var KEYCODE_ESC:Int = 27;

    /*
    public function new(caller:Function = null) {
        if (caller != InputManager.getInstance) {
            throw new Error("new禁止");
        }
    }
    */
    public function new() {
    }

    public static function getInstance():InputManager {
        if (m_Instance == null) {
//            m_Instance = new InputManager(arguments.callee);
            m_Instance = new InputManager();
        }
        return m_Instance;
    }

    public function init(stage:Stage):Void {
        if(m_bInit == true) { return; }

        m_Mouse = new Mouse();
        m_Keyboard = new Keyboard();
        m_Pad = new GamePad();

        m_Pad.setKeyboard(m_Keyboard);
        m_Pad.setMouse(m_Mouse);

        stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);

        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.addEventListener(MouseEvent.CLICK, onMouseClick);
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);

    }

    /**
     * フレームの開始に呼ぶ処理
     */
    public function beginFrame():Void {
    }

    /**
     * フレームの終了時に呼ぶ処理
     */
    public function endFrame():Void {
        m_Mouse.endFrame();
        m_Keyboard.endFrame();
    }

    private function onKeyDown(e:KeyboardEvent):Void {
        m_Keyboard.onKeyDown(e.keyCode);

        if(e.keyCode == KEYCODE_ESC) {
            if(Debug.isEscEnd) {
                trace("<<Applcation Terminate>>");
                throw new Error("Applcation Terminate.");
            }
        }
    }

    private function onKeyUp(e:KeyboardEvent):Void {
        m_Keyboard.onKeyUp(e.keyCode);
    }

    private function onMouseMove(e:MouseEvent):Void {
        m_Mouse.onMove(e);
    }

    private function onMouseClick(e:MouseEvent):Void {
        m_Mouse.onClick(e);
    }

    private function onMouseDown(e:MouseEvent):Void {
        m_Mouse.onDown(e);
    }

    private function onMouseUp(e:MouseEvent):Void {
        m_Mouse.onUp(e);
    }

    public function getPad():GamePad {
        return m_Pad;
    }

    public function isPressEnter(): Bool { return m_Pad.isPress(0); }
    public function isPressCancel(): Bool { return m_Pad.isPress(1); }
    public function isPressMenu(): Bool { return m_Pad.isPress(2); }
    public function isPressLeft(): Bool { return m_Pad.isPressLeft(); }
    public function isPressUp(): Bool { return m_Pad.isPressUp(); }
    public function isPressRight(): Bool { return m_Pad.isPressRight(); }
    public function isPressDown(): Bool { return m_Pad.isPressDown(); }

    public function isOnEnter(): Bool { return m_Pad.isOn(0); }
    public function isOnCancel(): Bool { return m_Pad.isOn(1); }
    public function isOnMenu(): Bool { return m_Pad.isOn(2); }
    public function isOnLeft(): Bool { return m_Pad.isOnLeft(); }
    public function isOnUp(): Bool { return m_Pad.isOnUp(); }
    public function isOnRight(): Bool { return m_Pad.isOnRight(); }
    public function isOnDown(): Bool { return m_Pad.isOnDown(); }


    public function getX(): Int { return m_Pad.getX(); }
    public function getY(): Int { return m_Pad.getY(); }
    public function x(): Int { return m_Pad.x(); }
    public function y(): Int { return m_Pad.y(); }

    public function isOnKey(key:String): Bool { return m_Pad.isOnKey(key); }
    public function isPressKey(key:String): Bool { return m_Pad.isPressKey(key); }
}
