package framework;

import framework.IScene;

/**
 * シーン管理
 * @author syun
 */
class SceneManager
{
    private static var m_Pool:Map<String, IScene> = new Map<String, IScene>();
    private static var m_Current:IScene;
    public function new() {
    }
    /**
     * シーンの追加
     * @param	name
     * @param	scene
     */
    public static function add(name:String, scene:IScene):Void {
        m_Pool[name] = scene;
        change(name);
    }
    /**
     * 現在のシーンを取得する
     */
    public static function get():IScene {
        return m_Current;
    }
    /**
     * シーンを切り替える
     * @param	name
     */
    public static function change(name:String):Void {
        m_Current = m_Pool[name];
    }
}
