#!/usr/bin/env python
# -*- coding: utf-8 -*-
from rplib.itoken import *
from rplib.rp import *
from rplib.scene import *


class Particle(Token):
	parent = None
	@classmethod
	def add(cls, id, x, y, deg=0, speed=0, ax=0, ay=0):
		cls.parent.add(id, x, y, deg, speed, ax, ay)
	def init(self, id):
		self.id = id
		self.timer = 60 - Util.randf(10)
		self.setSize(4, 4)
	def update(self):
		self.move()
		self.decay(0.9)
		self.timer -= 1
		if self.timer < 1:
			self.vanish()
		if self.isInArea() == False:
			self.vanish()
	def draw(self):
		self.drawEx(0, 255, 255)

class ParticleManager(TokenManager):
	def add(self, id, x, y, deg, speed, ax, ay):
		t = TokenManager.add(self)
		if t == None: return

		t.create(x, y, deg, speed, ax, ay)
		t.init(id)

class Enemy(Token):
	parent = None
	@classmethod
	def add(cls, id, x, y, deg=0, speed=0, ax=0, ay=0):
		cls.parent.add(id, x, y, deg, speed, ax, ay)
	def init(self, id):
		self.id = id
		self.setSize(8, 8)
	def update(self):
		pass
	def draw(self):
		self.drawEx(0, 255, 0)

class EnemyManager(TokenManager):
	def add(self, id, x, y, deg, speed, ax, ay):
		t = TokenManager.add(self)
		if t == None: return

		t.create(x, y, deg, speed, ax, ay)
		t.init(id)

class Player(Token):
	def __init__(self):
		self.x = 128
		self.y = 128
		self.setSize(8, 8)
	def update(self):
		speed = 5
		if self._i.isPressLeft():
			self.x -= 5
		if self._i.isPressUp():
			self.y -= 5
		if self._i.isPressRight():
			self.x += 5
		if self._i.isPressDown():
			self.y += 5
		self.clipInArea()

		#Particle.add(0, self.x, self.y, Util.randf(360), Util.randf2(5, 10))

	def draw(self):
		#self.drawEx(0, 0, 255)
		self._g.drawSpriteEx("mikuR1", self.x, self.y)


class SceneMain(Scene):
	def __init__(self):
		Enemy.parent    = EnemyManager("app.Enemy", 128)
		Particle.parent = ParticleManager("app.Particle", 256)
		self._g.load("all", "charset.bmp", -1)
		self._g.loadSprite("all", "resources/image/charset.csv")
	def init(self):
		self.player = Player()
		Enemy.add(0, 256, 256)
	def update(self):
		self.player.update()
		Enemy.parent.update()
		Particle.parent.update()
	def draw(self):
		self.player.draw()
		Enemy.parent.draw()
		Particle.parent.draw()

		self._f.drawAscii("enemy   :%d"%(Enemy.parent.count()), 0, 0)
		self._f.drawAscii("particle:%d"%(Particle.parent.count()), 0, 16)

class App:
	def __init__(self):
		title  = "Test"

		mainWidth = 0

		x      = mainWidth/2
		y      = 0
		width  = 640
		height = 480

		rp = Rp(title, width, height)
		self.rp = rp

		# Token初期化
		IToken.set(rp)
		# Tokenの有効エリアを設定
		Token.setArea(x, y, x + rp.width-mainWidth, y + rp.height)
		Token.setMainArea(x, y, x + rp.width-mainWidth, y + rp.height)

		# シーンの登録
		SceneManager.add("main", SceneMain())
		SceneManager.change("main")
		SceneManager.get().init()

	def start(self):
		while True:
			rp = self.rp
			rp.update()

			SceneManager.update()
			SceneManager.draw()

			rp.updateAfter()

app = App()
app.start()
