#!/usr/bin/env python
# -*- coding: utf-8 -*-

class CsvLoader:
	def __init__(self, fileName):
		self._header = []
		self._types = []
		self._datas = {}
		f = open(fileName)
		table = f.read()
		f.close()
		row = 0
		for line in table.split("\n"):
			#print line
			if line == "": break
			if row == 0:
				# HEADER
				self._header = line.split(",")

			elif row == 1:
				# TYPES
				self._types = line.split(",")

			else:
				# DATAS
				datas = line.split(",")
				data = {}
				key = 0
				for i, d in enumerate(datas):
					h = self._header[i]
					if h == "id":
						key = d
					data[h] = d
				self._datas[key] = data
			row += 1
	def indexToIdx(self, index):
		for i, k in enumerate(self._datas.keys()):
			if i == index:
				return k
		return 0
	def get(self, idx):
		idx = str(idx)
		if idx in self._datas:
			return self._datas[idx]
		print("CsvLoader.get() Not found id="+idx)
		raise "hoge"
		return None
	def getValue(self, idx, key):
		data = self.get(idx)
		if data is None:
			return None
		row = self._header.index(key)
		t = self._types[row]
		if t == "int":
			return int(data[key])
		else:
			return data[key]
	def size(self):
		return len(self._datas)
	def dump(self):
		print self._header
		print self._types
		for k, v in self._datas.items():
			print k, v

if __name__ == "__main__":
	csv = CsvLoader("test.csv")
	csv.dump()
	print(csv.getValue(3, "hp"))
	print(csv.getMessage(3, "name"))





