#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
import sys
import pygame.gfxdraw

# フォント管理
class RpFont:
	# ascii文字関連
	_ASCII_SIZE = 16          # 1文字あたりのサイズ
	_ASCII_KEY  = "__font"    # 画像キー
	_ASCII_COL  = (0, 255, 0) # 抜き色
	_ASCII_PATH = "resources/system/font.bmp" # ファイルパス

	def __init__(self, graphics):
		self.graphics = graphics
		graphics.load(self._ASCII_KEY, self._ASCII_PATH, self._ASCII_COL, True)

	def getSizeAscii(self): return self._ASCII_SIZE

	# ascii文字の描画
	def drawAscii(self, msg, x, y, alpha=255):

		# アルファ値設定
		self.graphics.setAlpha(self._ASCII_KEY, alpha)

		# 四角は「`」
		# 音符は「~」
		# ハートは「@」
		decode =  "0123456789ABCDEF"
		decode += "GHIJKLMNOPQRSTUV"
		decode += "WXYZabcdefghijkl"
		decode += "mnopqrstuvwxyz.("
		decode += ")[]#$%&'" + '"!?^+-*/'
		decode += '=;:_<>`\~@||||||'

		size = self._ASCII_SIZE
		px = x
		py = y
		for i, c in enumerate(msg):

			idx = decode.find(c)
			if(idx == -1):
				# 見つからない
				px += size
				continue

			ox = (idx % size) * size
			oy = int(idx / size) * size
			self.graphics.draw(self._ASCII_KEY, px, py, ox, oy, size, size)

			px += size

		# もとに戻す
		self.graphics.setAlpha(self._ASCII_KEY)

	def drawAsciiEx(self, msg, cx, cy, alpha=255):
		width = len(msg) * self._ASCII_SIZE
		height = self._ASCII_SIZE

		px = cx - width / 2
		py = cy - height / 2

		self.drawAscii(msg, px, py, alpha)
