﻿using UnityEngine;
using System.Collections;

public class Enemy : MonoBehaviour {

	public enum eType {
		Nasu = 0,
		Box5,
		Radish,
		Tako,
		Carrot,
		Pokky,
		Pudding = 17,
		Milk,
		XBox,
	}

	private GameObject _target = null;

	public static Enemy Add(eType type, Vector3 position, float direction, float speed) {
		GameObject prefab = (GameObject)Resources.Load ("Prefabs/Enemy");
		GameObject enemy = Instantiate (prefab, position, Quaternion.identity) as GameObject;
		Enemy e = enemy.GetComponent<Enemy>();
		e.Create(direction, speed);
		e.SetType(type);

		return e;
	}

	public void Create(float direction, float speed) {
		// Setting velocity.
		Vector2 v;
		v.x = Mathf.Cos (Mathf.Deg2Rad * direction) * speed;
		v.y = Mathf.Sin (Mathf.Deg2Rad * direction) * speed;
		rigidbody2D.velocity = v;
	}


	public void SetType(eType type) {
		string name = "enemy_" + (int)type;
		SpriteRenderer sr = GetComponent<SpriteRenderer>();
		Sprite sp = Util.GetSprite("Sprites/all", name);
		sr.sprite = sp;
	}

	// Use this for initialization
	void Start () {
	}


	public float GetAim() {
		if(_target == null) {
			_target = GameObject.FindWithTag ("Player");
		}
		Vector2 p1 = transform.position;
		Vector2 p2 = _target.transform.position;
		float dx = p2.x - p1.x;
		float dy = p2.y - p1.y;
		float rad = Mathf.Atan2(dy, dx);

		return rad * Mathf.Rad2Deg;
	}

	/// <summary>
	/// Bullet
	/// </summary>
	/// <param name="dir">Direction.</param>
	/// <param name="speed">Speed.</param>
	/// <param name="msWait">wait for msec.</param>
	private void DoBullet(float dir, float speed, float msWait=0f) {
		StartCoroutine(DoBulletCoroutine(dir, speed, msWait));
	}
	private IEnumerator DoBulletCoroutine(float dir, float speed, float msWait=0f) {
		if(msWait > 0f) {
			yield return new WaitForSeconds(msWait*0.001f);
		}
		Bullet.Add(transform.position, dir, speed);
	}

	private int timer = 0;

	void BulletWhip() {
		for(int j = 0; j < 3; j++) {
			float aim = GetAim() - 20 + j * 20;
			for(int i = 0; i < 8; i++) {
				float spd = 5 + i * 0.7f;
				float wait = 0 + i * 100;
				DoBullet(aim, spd, wait);
			}
		}
	}

	// Update is called once per frame
	void Update () {
		timer++;
		if(timer%120 == 0) {
			BulletWhip();
		}

		if(timer%240 < 120) {
			Vector2 v = new Vector2(0, -1);
			rigidbody2D.velocity = v;
		}
		else {
			Vector2 v = new Vector2(0, 1);
			rigidbody2D.velocity = v;
		}
	}

	void OnTriggerEnter2D(Collider2D c) {
		string name = LayerMask.LayerToName(c.gameObject.layer);
		if(name == "Shot") {
			Destroy (c.gameObject);
		}
	}
}
