/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.GraphOperation;
import jdd.graph.Node;
import jdd.graph.Topology;
import jdd.util.Test;

public class WeakTopologicalOrdering {
    private static int num;
    private static int tos;
    private static Node[] stack;
    private static boolean directed;

    public static Topology bourdoncle_PCG(Graph graph) {
        Node node = GraphOperation.lightNode(graph, true);
        return WeakTopologicalOrdering.bourdoncle_internal(graph, node, false);
    }

    public static Topology bourdoncle(Graph graph) {
        return WeakTopologicalOrdering.bourdoncle(graph, (Node)graph.getNodes().elementAt(0));
    }

    public static Topology bourdoncle(Graph graph, Node node) {
        return WeakTopologicalOrdering.bourdoncle_internal(graph, node, graph.isDirected());
    }

    private static Topology bourdoncle_internal(Graph graph, Node node, boolean bl) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        directed = bl;
        num = 0;
        tos = 0;
        if (stack == null || stack.length < graph.numOfNodes()) {
            stack = new Node[graph.numOfNodes()];
        }
        Topology topology = new Topology();
        topology.disjoint = true;
        do {
            Topology topology2 = new Topology();
            WeakTopologicalOrdering.bourdoncle_visit(node, topology2);
            topology.add(topology2);
        } while ((node = AttributeExplorer.findExtra1(graph, -1)) != null);
        return topology.simplify();
    }

    private static Topology bourdoncle_component(Node node) {
        Node node2;
        Topology topology = new Topology();
        Edge edge = node.firstOut;
        while (edge != null) {
            node2 = edge.n2;
            edge = edge.next;
            if (node2.extra1 != -1) continue;
            WeakTopologicalOrdering.bourdoncle_visit(node2, topology);
        }
        if (!directed) {
            edge = node.firstIn;
            while (edge != null) {
                node2 = edge.n1;
                edge = edge.prev;
                if (node2.extra1 != -1) continue;
                WeakTopologicalOrdering.bourdoncle_visit(node2, topology);
            }
        }
        topology.add(node);
        return topology;
    }

    private static int bourdoncle_visit(Node node, Topology topology) {
        int n;
        Node node2;
        WeakTopologicalOrdering.stack[WeakTopologicalOrdering.tos++] = node;
        node.extra1 = num++;
        int n2 = node.extra1;
        boolean bl = false;
        Edge edge = node.firstOut;
        while (edge != null) {
            node2 = edge.n2;
            edge = edge.next;
            n = node2.extra1 == -1 ? WeakTopologicalOrdering.bourdoncle_visit(node2, topology) : node2.extra1;
            if (n > n2) continue;
            n2 = n;
            bl = true;
        }
        if (!directed) {
            edge = node.firstIn;
            while (edge != null) {
                node2 = edge.n1;
                edge = edge.prev;
                n = node2.extra1 == -1 ? WeakTopologicalOrdering.bourdoncle_visit(node2, topology) : node2.extra1;
                if (n > n2) continue;
                n2 = n;
                bl = true;
            }
        }
        if (n2 == node.extra1) {
            node.extra1 = Integer.MAX_VALUE;
            node2 = stack[--tos];
            if (bl) {
                while (node2 != node) {
                    node2.extra1 = -1;
                    node2 = stack[--tos];
                }
                topology.add(WeakTopologicalOrdering.bourdoncle_component(node));
            } else {
                topology.add(node);
            }
        }
        return n2;
    }

    public static void internal_test() {
        Test.start("WeakTopologicalOrdering");
        Graph graph = GraphIO.loadEdgeList("data/tarjan.pcg");
        Topology topology = WeakTopologicalOrdering.bourdoncle(graph);
        Test.end();
    }

    static {
        stack = null;
    }
}

