/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.aop.javassist.EnhancedClassGenerator;
import org.seasar.framework.aop.javassist.MethodInvocationClassGenerator;
import org.seasar.framework.exception.NoSuchFieldRuntimeException;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassPoolUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;

public class AspectWeaver {
    public static final String PREFIX_ENHANCED_CLASS = "$$";
    public static final String SUFFIX_ENHANCED_CLASS = "$$EnhancedByS2AOP$$";
    public static final String SUFFIX_METHOD_INVOCATION_CLASS = "$$MethodInvocation$$";
    public static final String SUFFIX_INVOKE_SUPER_METHOD = "$$invokeSuperMethod$$";
    public static final String SEPARATOR_METHOD_INVOCATION_CLASS = "$$";
    protected static final Set enhancedClassNames = Collections.synchronizedSet(new HashSet());
    protected final Class targetClass;
    protected final Map parameters;
    protected final String enhancedClassName;
    protected final EnhancedClassGenerator enhancedClassGenerator;
    protected final List methodInvocationClassList = new ArrayList();
    protected Class enhancedClass;
    protected ClassPool classPool;

    public AspectWeaver(Class targetClass, Map parameters) {
        this.targetClass = targetClass;
        this.parameters = parameters;
        this.classPool = ClassPoolUtil.getClassPool(targetClass);
        this.enhancedClassName = this.getEnhancedClassName();
        this.enhancedClassGenerator = new EnhancedClassGenerator(this.classPool, targetClass, this.enhancedClassName);
    }

    public void setInterceptors(Method method, MethodInterceptor[] interceptors) {
        String methodInvocationClassName = this.getMethodInvocationClassName(method);
        MethodInvocationClassGenerator methodInvocationGenerator = new MethodInvocationClassGenerator(this.classPool, methodInvocationClassName, this.enhancedClassName);
        String invokeSuperMethodName = this.createInvokeSuperMethod(method);
        methodInvocationGenerator.createProceedMethod(method, invokeSuperMethodName);
        this.enhancedClassGenerator.createTargetMethod(method, methodInvocationClassName);
        Class methodInvocationClass = methodInvocationGenerator.toClass(ClassLoaderUtil.getClassLoader(this.targetClass));
        this.setStaticField(methodInvocationClass, "method", method);
        this.setStaticField(methodInvocationClass, "interceptors", interceptors);
        this.setStaticField(methodInvocationClass, "parameters", this.parameters);
        this.methodInvocationClassList.add(methodInvocationClass);
    }

    public void setInterTypes(InterType[] interTypes) {
        if (interTypes == null) {
            return;
        }
        for (int i = 0; i < interTypes.length; ++i) {
            this.enhancedClassGenerator.applyInterType(interTypes[i]);
        }
    }

    public Class generateClass() {
        if (this.enhancedClass == null) {
            this.enhancedClass = this.enhancedClassGenerator.toClass(ClassLoaderUtil.getClassLoader(this.targetClass));
            for (int i = 0; i < this.methodInvocationClassList.size(); ++i) {
                Class methodInvocationClass = (Class)this.methodInvocationClassList.get(i);
                this.setStaticField(methodInvocationClass, "targetClass", this.targetClass);
            }
        }
        return this.enhancedClass;
    }

    public String getEnhancedClassName() {
        StringBuffer buf = new StringBuffer(200);
        String targetClassName = this.targetClass.getName();
        Package pkg = this.targetClass.getPackage();
        if (targetClassName.startsWith("java.") || pkg != null && pkg.isSealed()) {
            buf.append("$$");
        }
        buf.append(targetClassName).append(SUFFIX_ENHANCED_CLASS).append(Integer.toHexString(this.hashCode()));
        int length = buf.length();
        int i = 0;
        while (enhancedClassNames.contains(new String(buf))) {
            buf.setLength(length);
            buf.append("_").append(i);
            ++i;
        }
        String name = new String(buf);
        enhancedClassNames.add(name);
        return name;
    }

    public String getMethodInvocationClassName(Method method) {
        return this.enhancedClassName + SUFFIX_METHOD_INVOCATION_CLASS + method.getName() + "$$" + this.methodInvocationClassList.size();
    }

    public String createInvokeSuperMethod(Method method) {
        String invokeSuperMethodName = "$$" + method.getName() + SUFFIX_INVOKE_SUPER_METHOD;
        if (!MethodUtil.isAbstract(method)) {
            this.enhancedClassGenerator.createInvokeSuperMethod(method, invokeSuperMethodName);
        }
        return invokeSuperMethodName;
    }

    public void setStaticField(Class clazz, String name, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            FieldUtil.set(field, name, value);
            field.setAccessible(false);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(this.enhancedClass, name, e);
        }
    }
}

