/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.ZipFileUtil;
import org.seasar.framework.util.ZipInputStreamUtil;

public class ResourcesUtil {
    protected static final Resources[] EMPTY_ARRAY = new Resources[0];
    private static final Logger logger = Logger.getLogger(ResourcesUtil.class);
    protected static final Map resourcesTypeFactories = new HashMap();

    public static void addResourcesFactory(String protocol, ResourcesFactory factory) {
        resourcesTypeFactories.put(protocol, factory);
    }

    public static Resources getResourcesType(Class referenceClass) {
        URL url = ResourceUtil.getResource(ResourcesUtil.toClassFile(referenceClass.getName()));
        String[] path = referenceClass.getName().split("\\.");
        String baseUrl = url.toExternalForm();
        for (int i = 0; i < path.length; ++i) {
            int pos = baseUrl.lastIndexOf(47);
            baseUrl = baseUrl.substring(0, pos);
        }
        return ResourcesUtil.getResourcesType(URLUtil.create(baseUrl + '/'), null, null);
    }

    public static Resources getResourcesType(String rootDir) {
        URL url = ResourceUtil.getResource(rootDir.endsWith("/") ? rootDir : rootDir + '/');
        return ResourcesUtil.getResourcesType(url, null, rootDir);
    }

    public static Resources[] getResourcesTypes(String rootPackage) {
        if (StringUtil.isEmpty(rootPackage)) {
            return EMPTY_ARRAY;
        }
        String baseName = ResourcesUtil.toDirectoryName(rootPackage);
        ArrayList<Resources> list = new ArrayList<Resources>();
        Iterator it = ClassLoaderUtil.getResources(baseName);
        while (it.hasNext()) {
            URL url = (URL)it.next();
            Resources resourcesType = ResourcesUtil.getResourcesType(url, rootPackage, baseName);
            if (resourcesType == null) continue;
            list.add(resourcesType);
        }
        if (list.isEmpty()) {
            logger.log("WSSR0014", new Object[]{rootPackage});
            return EMPTY_ARRAY;
        }
        return list.toArray(new Resources[list.size()]);
    }

    protected static Resources getResourcesType(URL url, String rootPackage, String rootDir) {
        ResourcesFactory factory = (ResourcesFactory)resourcesTypeFactories.get(URLUtil.toCanonicalProtocol(url.getProtocol()));
        if (factory != null) {
            return factory.create(url, rootPackage, rootDir);
        }
        logger.log("WSSR0013", new Object[]{rootPackage, url});
        return null;
    }

    protected static String toDirectoryName(String packageName) {
        if (StringUtil.isEmpty(packageName)) {
            return null;
        }
        return packageName.replace('.', '/') + '/';
    }

    protected static String toClassFile(String className) {
        return className.replace('.', '/') + ".class";
    }

    protected static File getBaseDir(URL url, String baseName) {
        File file = URLUtil.toFile(url);
        String[] paths = StringUtil.split(baseName, "/");
        for (int i = 0; i < paths.length; ++i) {
            file = file.getParentFile();
        }
        return file;
    }

    static {
        ResourcesUtil.addResourcesFactory("file", new ResourcesFactory(){

            public Resources create(URL url, String rootPackage, String rootDir) {
                return new FileSystemResources(ResourcesUtil.getBaseDir(url, rootDir), rootPackage, rootDir);
            }
        });
        ResourcesUtil.addResourcesFactory("jar", new ResourcesFactory(){

            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(url, rootPackage, rootDir);
            }
        });
        ResourcesUtil.addResourcesFactory("zip", new ResourcesFactory(){

            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(JarFileUtil.create(new File(ZipFileUtil.toZipFilePath(url))), rootPackage, rootDir);
            }
        });
        ResourcesUtil.addResourcesFactory("code-source", new ResourcesFactory(){

            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(URLUtil.create("jar:file:" + url.getPath()), rootPackage, rootDir);
            }
        });
        ResourcesUtil.addResourcesFactory("vfszip", new ResourcesFactory(){

            public Resources create(URL url, String rootPackage, String rootDir) {
                return new VfsZipResources(url, rootPackage, rootDir);
            }
        });
    }

    public static class VfsZipResources
    implements Resources {
        protected static final String WAR_CLASSES_PREFIX = "/WEB-INF/CLASSES/";
        protected final String rootPackage;
        protected final String rootDir;
        protected final URL zipUrl;
        protected final String prefix;
        protected final Set entryNames = new HashSet();

        public VfsZipResources(URL url, String rootPackage, String rootDir) {
            String zipUrlString;
            URL zipUrl = url;
            String prefix = "";
            if (rootPackage != null) {
                String[] paths = rootPackage.split("\\.");
                for (int i = 0; i < paths.length; ++i) {
                    zipUrl = URLUtil.create(zipUrl, "..");
                }
            }
            this.loadFromZip(zipUrl);
            if (this.entryNames.isEmpty() && (zipUrlString = zipUrl.toExternalForm()).toUpperCase().endsWith(WAR_CLASSES_PREFIX)) {
                URL warUrl = URLUtil.create(zipUrl, "../..");
                String path = warUrl.getPath();
                zipUrl = FileUtil.toURL(new File(path.substring(0, path.length() - 1)));
                prefix = zipUrlString.substring(warUrl.toExternalForm().length());
                this.loadFromZip(zipUrl);
            }
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
            this.zipUrl = zipUrl;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFromZip(URL zipUrl) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(zipUrl));
            try {
                ZipEntry entry = null;
                while ((entry = ZipInputStreamUtil.getNextEntry(zis)) != null) {
                    this.entryNames.add(entry.getName());
                    ZipInputStreamUtil.closeEntry(zis);
                }
            }
            finally {
                InputStreamUtil.close(zis);
            }
        }

        public boolean isExistClass(String className) {
            String entryName = this.prefix + ResourcesUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className));
            return this.entryNames.contains(entryName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(ClassTraversal.ClassHandler handler) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(this.zipUrl));
            try {
                ClassTraversal.forEach(zis, this.prefix, new ClassTraversal.ClassHandler(this, handler){
                    private final /* synthetic */ ClassTraversal.ClassHandler val$handler;
                    private final /* synthetic */ VfsZipResources this$0;
                    {
                        this.this$0 = this$0;
                        this.val$handler = val$handler;
                    }

                    public void processClass(String packageName, String shortClassName) {
                        if (this.this$0.rootPackage == null || packageName != null && packageName.startsWith(this.this$0.rootPackage)) {
                            this.val$handler.processClass(packageName, shortClassName);
                        }
                    }
                });
            }
            finally {
                InputStreamUtil.close(zis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(ResourceTraversal.ResourceHandler handler) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(this.zipUrl));
            try {
                ResourceTraversal.forEach(zis, this.prefix, new ResourceTraversal.ResourceHandler(this, handler){
                    private final /* synthetic */ ResourceTraversal.ResourceHandler val$handler;
                    private final /* synthetic */ VfsZipResources this$0;
                    {
                        this.this$0 = this$0;
                        this.val$handler = val$handler;
                    }

                    public void processResource(String path, InputStream is) {
                        if (this.this$0.rootDir == null || path.startsWith(this.this$0.rootDir)) {
                            this.val$handler.processResource(path, is);
                        }
                    }
                });
            }
            finally {
                InputStreamUtil.close(zis);
            }
        }

        public void close() {
        }
    }

    public static class JarFileResources
    implements Resources {
        protected final JarFile jarFile;
        protected final String rootPackage;
        protected final String rootDir;

        public JarFileResources(JarFile jarFile, String rootPackage, String rootDir) {
            this.jarFile = jarFile;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public JarFileResources(URL url, String rootPackage, String rootDir) {
            this(JarFileUtil.toJarFile(url), rootPackage, rootDir);
        }

        public boolean isExistClass(String className) {
            return this.jarFile.getEntry(ResourcesUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className))) != null;
        }

        public void forEach(ClassTraversal.ClassHandler handler) {
            ClassTraversal.forEach(this.jarFile, new ClassTraversal.ClassHandler(this, handler){
                private final /* synthetic */ ClassTraversal.ClassHandler val$handler;
                private final /* synthetic */ JarFileResources this$0;
                {
                    this.this$0 = this$0;
                    this.val$handler = val$handler;
                }

                public void processClass(String packageName, String shortClassName) {
                    if (this.this$0.rootPackage == null || packageName != null && packageName.startsWith(this.this$0.rootPackage)) {
                        this.val$handler.processClass(packageName, shortClassName);
                    }
                }
            });
        }

        public void forEach(ResourceTraversal.ResourceHandler handler) {
            ResourceTraversal.forEach(this.jarFile, new ResourceTraversal.ResourceHandler(this, handler){
                private final /* synthetic */ ResourceTraversal.ResourceHandler val$handler;
                private final /* synthetic */ JarFileResources this$0;
                {
                    this.this$0 = this$0;
                    this.val$handler = val$handler;
                }

                public void processResource(String path, InputStream is) {
                    if (this.this$0.rootDir == null || path.startsWith(this.this$0.rootDir)) {
                        this.val$handler.processResource(path, is);
                    }
                }
            });
        }

        public void close() {
            JarFileUtil.close(this.jarFile);
        }
    }

    public static class FileSystemResources
    implements Resources {
        protected final File baseDir;
        protected final String rootPackage;
        protected final String rootDir;

        public FileSystemResources(File baseDir, String rootPackage, String rootDir) {
            this.baseDir = baseDir;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public FileSystemResources(URL url, String rootPackage, String rootDir) {
            this(URLUtil.toFile(url), rootPackage, rootDir);
        }

        public boolean isExistClass(String className) {
            File file = new File(this.baseDir, ResourcesUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className)));
            return file.exists();
        }

        public void forEach(ClassTraversal.ClassHandler handler) {
            ClassTraversal.forEach(this.baseDir, this.rootPackage, handler);
        }

        public void forEach(ResourceTraversal.ResourceHandler handler) {
            ResourceTraversal.forEach(this.baseDir, this.rootDir, handler);
        }

        public void close() {
        }
    }

    public static interface Resources {
        public boolean isExistClass(String var1);

        public void forEach(ClassTraversal.ClassHandler var1);

        public void forEach(ResourceTraversal.ResourceHandler var1);

        public void close();
    }

    public static interface ResourcesFactory {
        public Resources create(URL var1, String var2, String var3);
    }
}

