/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.extension.httpsession.SessionState;
import org.seasar.extension.httpsession.SessionStateManager;
import org.seasar.extension.jdbc.impl.BasicBatchHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.jdbc.impl.MapListResultSetHandler;
import org.seasar.framework.util.SerializeUtil;

public class DbSessionStateManagerImpl
implements SessionStateManager {
    private static final String SELECT_SQL = "select name, value, last_access from s2session where session_id = ?";
    private static final String INSERT_SQL = "insert into s2session values(?, ?, ?, ?)";
    private static final String UPDATE_SQL = "update s2session set value = ?, last_access = ? where session_id = ? and name = ?";
    private static final String DELETE_SQL = "delete from s2session where session_id = ? and name = ?";
    private static final String DELETE_ALL_SQL = "delete from s2session where session_id = ?";
    private DataSource dataSource;
    private boolean batchUpdateDisabled;

    public DbSessionStateManagerImpl() {
    }

    public DbSessionStateManagerImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setBatchUpdateDisabled(boolean batchUpdateDisabled) {
        this.batchUpdateDisabled = batchUpdateDisabled;
    }

    public SessionState loadState(String sessionId) {
        BasicSelectHandler handler = new BasicSelectHandler(this.dataSource, SELECT_SQL, new MapListResultSetHandler());
        List result = (List)handler.execute(new String[]{sessionId});
        HashMap binaryData = new HashMap(result.size());
        long lastAccessedTime = System.currentTimeMillis();
        for (int i = 0; i < result.size(); ++i) {
            Map m = (Map)result.get(i);
            binaryData.put(m.get("name"), m.get("value"));
            Timestamp lastAccess = (Timestamp)m.get("lastAccess");
            if (lastAccess == null) continue;
            lastAccessedTime = lastAccess.getTime();
        }
        return new SessionState(binaryData, lastAccessedTime);
    }

    public void removeState(String sessionId) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.dataSource, DELETE_ALL_SQL);
        handler.execute(new Object[]{sessionId});
    }

    public void updateState(String sessionId, SessionState sessionState) {
        ArrayList<Object[]> insertedData = new ArrayList<Object[]>();
        ArrayList<Object[]> updatedData = new ArrayList<Object[]>();
        ArrayList<Object[]> deletedData = new ArrayList<Object[]>();
        Timestamp lastAccess = new Timestamp(new Date().getTime());
        Enumeration e = sessionState.getAccessedAttributeNames();
        while (e.hasMoreElements()) {
            byte[] value;
            String name = (String)e.nextElement();
            if (sessionState.needInsert(name)) {
                value = SerializeUtil.fromObjectToBinary((Object)sessionState.getAttribute(name));
                insertedData.add(new Object[]{sessionId, name, value, lastAccess});
                continue;
            }
            if (sessionState.needUpdate(name)) {
                value = SerializeUtil.fromObjectToBinary((Object)sessionState.getAttribute(name));
                updatedData.add(new Object[]{value, lastAccess, sessionId, name});
                continue;
            }
            if (!sessionState.needDelete(name)) continue;
            deletedData.add(new Object[]{sessionId, name});
        }
        this.execute(INSERT_SQL, insertedData);
        this.execute(UPDATE_SQL, updatedData);
        this.execute(DELETE_SQL, deletedData);
        sessionState.persisted();
    }

    protected void execute(String sql, List data) {
        if (data.size() == 0) {
            return;
        }
        if (this.batchUpdateDisabled) {
            this.executeUpdate(sql, data);
        } else {
            this.executeBatch(sql, data);
        }
    }

    protected void executeBatch(String sql, List data) {
        BasicBatchHandler handler = new BasicBatchHandler(this.dataSource, sql);
        handler.execute(data);
    }

    protected void executeUpdate(String sql, List data) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.dataSource, sql);
        Iterator i = data.iterator();
        while (i.hasNext()) {
            handler.execute((Object[])i.next());
        }
    }
}

