/*
 * $Id: RequestProcessor.java 680350 2008-07-28 13:32:29Z niallp $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.config.ModuleConfig;


/**
 * <p><strong>RequestProcessor</strong> contains the processing logic that the
 * {@link ActionServlet} performs as it receives each servlet request from the
 * container. You can customize the request processing behavior by subclassing
 * this class and overriding the method(s) whose behavior you are interested
 * in changing.</p>
 *
 * @version $Rev: 680350 $ $Date: 2008-07-28 08:32:29 -0500 (Mon, 28 Jul 2008) $
 * @since Struts 1.1
 */
public interface RequestProcessor {

    // --------------------------------------------------------- Public Methods

    /**
     * <p>Clean up in preparation for a shutdown of this application.</p>
     */
    void destroy();

    /**
     * <p>Initialize this request processor instance.</p>
     *
     * @param servlet      The ActionServlet we are associated with
     * @param moduleConfig The ModuleConfig we are associated with.
     * @throws ServletException If an error occor during initialization
     */
    void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException;

    /**
     * <p>Process an <code>HttpServletRequest</code> and create the
     * corresponding <code>HttpServletResponse</code> or dispatch to another
     * resource.</p>
     *
     * @param request  The servlet request we are processing
     * @param response The servlet response we are creating
     * @throws IOException      if an input/output error occurs
     * @throws ServletException if a processing exception occurs
     */
    void process(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException;
}
