package org.apache.struts.util;

import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * PropertyMessageDefaultLocaleResources
 *
 */
public class PropertyMessageDefaultLocaleResources extends PropertyMessageResources {

    /** serialVersionUID */
    private static final long serialVersionUID = -2652812359738418093L;

    /**
     * The <code>Log</code> instance for this class.
     */
    private static final Log LOG = LogFactory.getLog(PropertyMessageDefaultLocaleResources.class);

    /**
     * Construct a new PropertyMessageResources according to the specified
     * parameters.
     *
     * @param config  The configuration parameter for this MessageResources
     */
    public PropertyMessageDefaultLocaleResources(final String config) {
        super(config);
    }

    /**
     * Construct a new PropertyMessageResources according to the specified
     * parameters.
     *
     * @param config     The configuration parameter for this
     *                   MessageResources
     * @param returnNull The returnNull property we should initialize with
     */
    public PropertyMessageDefaultLocaleResources(final String config, final boolean returnNull) {
        super(config, returnNull);
    }

    /**
     * Construct a new PropertyMessageResources according to the specified
     * parameters.
     *
     * @param config     The configuration parameter for this
     *                   MessageResources
     * @param returnNull The returnNull property we should initialize with
     * @param escape escape processing
     */
    public PropertyMessageDefaultLocaleResources(
            final String config, final boolean returnNull, final boolean escape) {
        super(config, returnNull, escape);
    }

    /**
     * Returns a text message for the specified key, for the specified or default
     * Locale. A null string result will be returned by this method if no relevant
     * message resource is found for this key or Locale, if the
     * <code>returnNull</code> property is set.  Otherwise, an appropriate
     * error message will be returned. <p> This method must be implemented by
     * a concrete subclass.
     *
     * @param locale The requested message Locale, or <code>null</code> for
     *               the system default Locale
     * @param key    The message key to look up
     * @return text message for the specified key and locale
     */
    @Override
    public String getMessage(final Locale locale, final String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMessage(" + locale + "," + key + ")");
        }

        // Initialize variables we will require
        String localeKey = localeKey(locale);
        String originalKey = messageKey(localeKey, key);

        // Search the specified Locale
        String message = findMessage(locale, key, originalKey);
        // PropertyResourcesBundle - searches through the hierarchy
        // for the default Locale (e.g. first en_US then en)
        if (message == null && !super.getDefaultLocale().equals(locale)) {
            message = findMessage(getDefaultLocale(), key, originalKey);
        }

        if (message == null) {
            // Find the message in the default properties file
            message = findMessage("", key, originalKey);
        }

        if (message != null) {
            return message;
        }

        // Return an appropriate error indication
        if (super.getReturnNull()) {
            return null;
        }

        return "???" + messageKey(locale, key) + "???";
    }
}
