/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.web;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import java.util.Arrays;
import java.util.Collection;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertNotNull;

/**
 *  Test case for org.apache.commons.chain2.web.ChainResources *
 */
@RunWith(Parameterized.class)
public final class ChainResourcesTestCase {

    // ----------------------------------------------------- Public constructor

    private final String input;

    private final String[] expected;

    /**
     * @param in String
     * @param exp String[]
     */
    public ChainResourcesTestCase(final String in, final String[] exp) {
        this.input = in;
        this.expected = exp.clone();
    }

    // ----------------------------------------------------- Test data source
    /**
     * @return Collection
     */
    @Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
            {"a,b,c", new String[] {"a", "b", "c"} },
            {"a , b , c ", new String[] {"a", "b", "c"} },
            {"a,\tb,\tc ", new String[] {"a", "b", "c"} },
            {"\na,\nb,\nc\n", new String[] {"a", "b", "c"} },
            {"a,,b,c ", new String[] {"a", "b", "c"} },
            {",a,b,,c,,", new String[] {"a", "b", "c"} },
            {null, new String[] {} },
            {"", new String[] {} },
            {",", new String[] {} },
            {",,", new String[] {} }
        });
    }

    // ------------------------------------------------ Individual Test Methods

    /**
     * testGetPaths
     */
    @Test
    public void testGetPaths() {
        String[] actual = ChainResources.getResourcePaths(this.input);

        assertNotNull(actual);
        assertArrayEquals(this.expected, actual);
    }

}
