package batch.base;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

import core.util.bean.Pair;

/**
 * バッチ作成のための親抽象クラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class BaseBatch implements Batch {

	/** メッセージテキスト */
	private String message = null;
	/** 作成ファイルリスト */
	private final CopyOnWriteArrayList<Pair<String, String>> fileList =
					new CopyOnWriteArrayList<>();

	/**
	 * メッセージ取得
	 *
	 * @return メッセージ
	 */
	@Override
	public final String getMessage() {
		return this.message;
	}

	/**
	 * メッセージ設定
	 *
	 * @param val メッセージ
	 */
	public final void setMessage(final String val) {
		this.message = val;
	}

	/**
	 * ファイルリスト取得
	 *
	 * @return ファイルリスト
	 */
	@Override
	public final List<Pair<String, String>> getOutputFiles() {
		return Collections.unmodifiableList(this.fileList);
	}

	/**
	 * ファイル設定
	 *
	 * @param file ファイル名（フルパス）
	 * @param download ダウンロード名
	 */
	protected final void addFile(final String file, final String download) {
		if (Objects.toString(download, "").trim().isEmpty()) {
			this.fileList.add(new Pair<>(file, null));
		} else {
			this.fileList.add(new Pair<>(file, download));
		}
	}
}
