-- SelectJobFile=
SELECT
  JOB_SEQ             AS JOB_SEQ,
  BAT_SEQ             AS BAT_SEQ,
  FILE_SEQ            AS FILE_SEQ,
  FILE_NAME           AS FILE_NAME,
  FILE_PATH           AS FILE_PATH,
  FILE_SIZE           AS FILE_SIZE,
  DOWNLOAD_NAME       AS DOWNLOAD_NAME,
  DOWNLOAD_COUNT      AS DOWNLOAD_COUNT
FROM
  FW_JOB_FILE
WHERE
  JOB_SEQ = /*:JobSeq*/123
  AND BAT_SEQ = /*:BatSeq*/123
  AND FILE_SEQ = /*:FileSeq*/123
;
-- SelectJobFileWithLock=
SELECT
  JOB_SEQ             AS JOB_SEQ,
  BAT_SEQ             AS BAT_SEQ,
  FILE_SEQ            AS FILE_SEQ,
  FILE_NAME           AS FILE_NAME,
  FILE_PATH           AS FILE_PATH,
  FILE_SIZE           AS FILE_SIZE,
  DOWNLOAD_NAME       AS DOWNLOAD_NAME,
  DOWNLOAD_COUNT      AS DOWNLOAD_COUNT
FROM
  FW_JOB_FILE
WHERE
  JOB_SEQ = /*:JobSeq*/123
  AND BAT_SEQ = /*:BatSeq*/123
  AND FILE_SEQ = /*:FileSeq*/123
FOR UPDATE
;
-- SelectJobFileList=
SELECT
  JOB_SEQ             AS JOB_SEQ,
  BAT_SEQ             AS BAT_SEQ,
  FILE_SEQ            AS FILE_SEQ,
  FILE_NAME           AS FILE_NAME,
  FILE_PATH           AS FILE_PATH,
  FILE_SIZE           AS FILE_SIZE,
  DOWNLOAD_NAME       AS DOWNLOAD_NAME,
  DOWNLOAD_COUNT      AS DOWNLOAD_COUNT
FROM
  FW_JOB_FILE
WHERE
  JOB_SEQ = /*:JobSeq*/123
ORDER BY
  BAT_SEQ DESC,
  FILE_SEQ DESC
;
-- UpdateJobFile=
UPDATE
  FW_JOB_FILE
SET
  DOWNLOAD_COUNT = /*:Count*/111,
  FILE_SIZE = /*:FileSize*/1024
WHERE
  JOB_SEQ = /*:JobSeq*/123
  AND BAT_SEQ = /*:BatSeq*/123
  AND FILE_SEQ = /*:FileSeq*/123
;
-- DeleteJobFile=
DELETE
FROM
  FW_JOB_FILE
WHERE
  JOB_SEQ = /*:JobSeq*/123
;
-- InsertJobFile=
INSERT INTO
  FW_JOB_FILE
(
  JOB_SEQ,
  BAT_SEQ,
  FILE_SEQ,
  FILE_NAME,
  FILE_PATH,
  FILE_SIZE,
  DOWNLOAD_NAME,
  DOWNLOAD_COUNT
) VALUES(
  /*:JobSeq*/123,
  /*:BatSeq*/123,
  /*:FileSeq*/123,
  /*:FileName*/'123',
  /*:FilePath*/'123',
  /*:FileSize*/1024,
  /*:DownloadName*/'Download',
  /*:Count*/111
)
;
