CREATE TABLE FW_JOB_REPEAT
(
    ID                          BIGINT PRIMARY KEY,
    JOB_ID                      VARCHAR(32)   NOT NULL,
    JOB_NAME                    VARCHAR(128)  NOT NULL,
    BAT_PARAM                   VARCHAR(512),
    DISP_PARAM                  VARCHAR(512),
    INTERVAL                    VARCHAR(8),
    HOUR                        CHAR(2),
    MINUTE                      CHAR(2),
    WEEK                        CHAR(1),
    YEAR_MONTH_DAY              VARCHAR(8),
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR(32)  NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR(32)  NOT NULL,
    VERSION                     INTEGER      NOT NULL DEFAULT 1
)
;

COMMENT ON TABLE FW_JOB_REPEAT IS 'ジョブ定期起動';
COMMENT ON COLUMN FW_JOB_REPEAT.ID IS 'ID';
COMMENT ON COLUMN FW_JOB_REPEAT.JOB_ID IS 'ジョブID';
COMMENT ON COLUMN FW_JOB_REPEAT.JOB_NAME IS 'ジョブ名';
COMMENT ON COLUMN FW_JOB_REPEAT.BAT_PARAM IS 'バッチ起動パラメタ';
COMMENT ON COLUMN FW_JOB_REPEAT.DISP_PARAM IS 'バッチ起動パラメタ（表示用）';
COMMENT ON COLUMN FW_JOB_REPEAT.INTERVAL IS '実行間隔';
COMMENT ON COLUMN FW_JOB_REPEAT.HOUR IS '実行時';
COMMENT ON COLUMN FW_JOB_REPEAT.MINUTE IS '実行分';
COMMENT ON COLUMN FW_JOB_REPEAT.WEEK IS '実行曜日';
COMMENT ON COLUMN FW_JOB_REPEAT.YEAR_MONTH_DAY IS '実行年月日/月日/日';
COMMENT ON COLUMN FW_JOB_REPEAT.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN FW_JOB_REPEAT.INSERT_ID IS '作成ID';
COMMENT ON COLUMN FW_JOB_REPEAT.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN FW_JOB_REPEAT.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN FW_JOB_REPEAT.VERSION IS 'バージョン';
