package common.transaction.provider;

import javax.transaction.UserTransaction;

import org.seasar.extension.jta.UserTransactionImpl;

import common.db.jdbc.provider.S2DataSourceProvider;
import common.transaction.UserTransactionProvider;

/**
 * S2UserTransactionProvider
 * @author Tadashi Nakayama
 */
public final class S2UserTransactionProvider implements UserTransactionProvider {

	/**
	 * @see common.transaction.UserTransactionProvider#getUserTransaction()
	 */
	@Override
	public UserTransaction getUserTransaction() {
		return new UserTransactionImpl(S2DataSourceProvider.getTransactionManager());
	}
}
