package online.jndi.factory;

import java.util.Hashtable;
import java.util.Objects;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;

import org.seasar.extension.jta.UserTransactionImpl;

import common.db.jdbc.provider.S2DataSourceProvider;

/**
 * TransactionManagerファクトリクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class S2JTAUserTransactionFactory implements ObjectFactory {

	/**
	 * @see ObjectFactory#getObjectInstance(java.lang.Object,
	 * javax.naming.Name, javax.naming.Context, java.util.Hashtable)
	 */
	@Override
	public Object getObjectInstance(final Object obj, final Name name,
					final Context ctx, final Hashtable<?, ?> env) throws Exception {
		// 設定処理は行わない。タイムアウトは設定ファイルで行う。
		String str = Objects.toString(name, "");
		if ("UserTransaction".equalsIgnoreCase(str)) {
			return new UserTransactionImpl(S2DataSourceProvider.getTransactionManager());
		}

		if ("TransactionManager".equalsIgnoreCase(str)) {
			return S2DataSourceProvider.getTransactionManager();
		}
		return null;
	}
}
