package online.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.logging.log4j.LogManager;
import org.seasar.extension.timer.TimeoutManager;

import common.db.JdbcSource;
import javassist.ClassClassPath;
import javassist.ClassPool;

/**
 * ドライバ抹消リスナ
 * @author Tadashi Nakayama
 */
public final class S2ContextListener implements ServletContextListener {

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(final ServletContextEvent arg0) {

		JdbcSource.deregister(this.getClass().getClassLoader());

		try {
			if (TimeoutManager.getInstance().stop(3000)) {
				return;
			}
		} catch (final InterruptedException e) {
			Thread.interrupted();
			LogManager.getLogger().info(e.getMessage());
		}

		LogManager.getLogger().info("TimeoutManager is still alive.");
	}

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextInitialized(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextInitialized(final ServletContextEvent arg0) {
		ClassPool pool = ClassPool.getDefault();
		pool.appendClassPath(new ClassClassPath(this.getClass()));
	}
}
