package project.check.range;

import java.util.Optional;

import core.util.ArrayUtil;
import core.util.NumberUtil;
import core.util.bean.Pair;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 指定範囲内チェック
 *
 * @author Tadashi Nakayama
 */
public final class NumeralRangeCheck extends BaseCheck {

	/** 最大数 */
	private final long maxval;
	/** 最小数 */
	private final long minval;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 *
	 * @param min 指定最小文字数
	 * @param max 指定最大文字数
	 */
	public NumeralRangeCheck(final long min, final long max) {
		this.minval = min;
		this.maxval = max;
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param min 指定最小文字数
	 * @param max 指定最大文字数
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public NumeralRangeCheck(final long min, final long max,
					final String msgId, final String... param) {
		this.minval = min;
		this.maxval = max;
		this.mid = msgId;
		this.prm = ArrayUtil.extend(param, String.valueOf(max), String.valueOf(min));
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
					continue;
				}
				Long num = NumberUtil.toLong(val[j]);
				if (num != null && (num.longValue() > this.maxval
								|| num.longValue() < this.minval)) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
