<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8" />
<title>汎用CSV抽出</title>
<link rel="stylesheet" href="view/css/import.css" />
</head>

<body>
<header>
	<nav></nav>
	<section></section>
</header>
<main>
	<header>
		<h3>ダウンロード項目選択</h3>
		<div id="topMessage">${MESSAGE}</div>
	</header>
	<section>
		<form id="search" method="post" action="${ACTION_PATH}">
		<div>
			<label for="defineName">使用定義名:</label>
			<select name="DefineName" id="defineName">
				<c:forEach items="${band.DefineNameValue}" var="bind">
					<utl:selected var="sel" name="DefineName" value="${bind.DefineNameValue}" />
					<option value="${sel}">${bind.DefineNameLabel}</option>
				</c:forEach>
			</select>
			<button type="button" class="search">検索</button>
		</div>
		</form>

		<c:if test="${fn:contains(RESPONSE_QUERY, 'Id=')}">
		<utl:encode var="fname" value="${UserPatternName}.csv" encoding="UTF-8" />
		<div>
		<form method="get" action="EXPORT/${fname}">
			<input type="hidden" name="Id" value="${Id}" />
			<button type="submit">ダウンロード</button>
		</form>
		</div>
		<a class="detail" href="javascript:void(0);">詳細設定</a>
		</c:if>

		<form id="form" method="post" style="${AID eq 'search' ? '' : 'display:none'}" onsubmit="return false;">
		<input type="hidden" name="Version" value="${empty Version ? '1' : Version}" />
		<input type="hidden" name="DefineName" value="${DefineName}" />
		<c:if test="${fn:length(array.ItemValue) gt 0}">
		<div>
			<label>項目名出力:</label>
			<utl:checked var="chk" name="Header" value="1" />
			<input type="checkbox" name="Header" value="${chk}" id="hd" />
			<label for="hd">あり</label>
		</div>

		<div>
			<table class="fixborder dnd float_left right_space">
			<caption>【項目】</caption>
			<thead>
				<tr class="nodrop nodrag">
					<th>
						出力
					</th>
					<th>
						項目名
					</th>
					<th>
						集計
					</th>
					<th>
						集約
					</th>
					<th>
						改頁
					</th>
				</tr>
			</thead>
			<c:forEach items="${band.ItemValue}" var="bind" varStatus="sts">
			<tbody>
				<tr>
					<td class="center">
						<utl:checked var="chk" name="Output" value="${bind.ItemValue}" default="${bind.ItemValue}" />
						<input type="checkbox" name="Output" value="${chk}" class="nodrag" />
					</td>
					<td>
						<input type="hidden" name="ItemValue" value="${bind.ItemValue}" />
						<input type="hidden" name="ItemLabel" value="${bind.ItemLabel}" />
						${bind.ItemLabel}
					</td>
					<td>
						<select name="AggregationKbn">
							<option value=""></option>
							<utl:selected var="sel" name="AggregationKbn" value="1" index="${sts.index}" />
							<option value="${sel}">AVG</option>
							<utl:selected var="sel" name="AggregationKbn" value="2" index="${sts.index}" />
							<option value="${sel}">COUNT</option>
							<utl:selected var="sel" name="AggregationKbn" value="3" index="${sts.index}" />
							<option value="${sel}">MAX</option>
							<utl:selected var="sel" name="AggregationKbn" value="4" index="${sts.index}" />
							<option value="${sel}">MIN</option>
							<utl:selected var="sel" name="AggregationKbn" value="5" index="${sts.index}" />
							<option value="${sel}">SUM</option>
						</select>
					</td>
					<td class="center">
						<utl:checked var="chk" name="Grouping" value="${bind.ItemValue}" />
						<input type="checkbox" name="Grouping" value="${chk}" class="nodrag" />
					</td>
					<td class="center">
						<utl:checked var="chk" name="PageBreak" value="${bind.ItemValue}" />
						<input type="checkbox" name="PageBreak" value="${chk}" class="nodrag" />
					</td>
				</tr>
			</tbody>
			</c:forEach>
			</table>

			<table class="fixborder dnd">
			<caption>【順序】</caption>
			<thead>
				<tr class="nodrop nodrag">
					<th>
						項目名
					</th>
					<th>
						昇降
					</th>
				</tr>
			</thead>
			<c:set var="val" value="${not empty OrderItem ? array.OrderItem : array.ItemValue}" />
			<c:set var="lbl" value="${not empty OrderLabel ? array.OrderLabel : array.ItemLabel}" />
			<c:forEach items="${val}" varStatus="st1">
			<tbody>
				<tr>
					<c:set var="idx" value="${st1.index}" />
					<c:if test="${empty OrderItem}">
					<c:forEach items="${array.OrderSort}" varStatus="st2">
						<c:if test="${not empty array.OrderSort[st2.index] and array.OrderSort[st2.index] eq array.DtlNo[idx]}">
						<c:set var="idx" value="${st2.index}" />
						</c:if>
					</c:forEach>
					</c:if>
					<td>
						<input type="hidden" name="OrderItem" value="${val[idx]}" />
						<input type="hidden" name="OrderLabel" value="${lbl[idx]}" />
						${lbl[idx]}
					</td>
					<td>
						<select name="OrderFlg">
							<option></option>
							<utl:selected var="sel" name="OrderFlg" value="0" index="${idx}" />
							<option value="${sel}">▲昇順</option>
							<utl:selected var="sel" name="OrderFlg" value="1" index="${idx}" />
							<option value="${sel}">▽降順</option>
						</select>
					</td>
				</tr>
			</tbody>
			</c:forEach>
			</table>
		</div>

		<div style="overflow-x:scroll">
			<table id="condTable" class="fixborder dnd">
			<caption>【条件】</caption>
			<thead>
				<tr class="nodrag nodrop">
					<th></th>
					<th colspan="2">
					<a href="javascript:void(0);" class="addcol">追加→</a>
					</th>
					<c:forEach begin="2" end="${ConditionColumn}">
					<th colspan="2" class="center">
					<button type="button" class="delcol">削除</button>
					</th>
					</c:forEach>
				</tr>
				<tr class="nodrag nodrop item">
					<td><a href="javascript:void(0);" class="addrow">追加↓</a></td>
					<c:forEach begin="1" end="${not empty ConditionColumn ? ConditionColumn : 1}" varStatus="sts" >
					<td colspan="2" class="center">
						<select name="ItemName">
							<option></option>
							<c:forEach items="${band.ItemValue}" var="bind">
								<utl:selected var="sel" name="ItemName" value="${bind.ItemValue}" index="${sts.index - 1}" />
								<option value="${sel}">${bind.ItemLabel}</option>
							</c:forEach>
						</select>
					</td>
					</c:forEach>
				</tr>
			</thead>
			<c:forEach items="${array.Operator}" varStatus="sts" >
			<c:if test="${empty ConditionColumn or sts.index mod ConditionColumn eq 0}">
			<c:if test="${not sts.first}">
				<c:out value="</tr>" escapeXml="false" />
				<c:out value="</tbody>" escapeXml="false" />
			</c:if>
				<c:out value="<tbody>" escapeXml="false" />
				<c:out value="<tr>" escapeXml="false" />
				<td class="center">
					<button type="button" class="remove">削除</button>
				</td>
			</c:if>
				<td class="center">
					<select name="Operator">
						<option></option>
						<utl:selected var="sel" name="Operator" value="EQ" index="${i.index}" />
						<option value="${sel}">=</option>
						<utl:selected var="sel" name="Operator" value="NE" index="${i.index}" />
						<option value="${sel}">!=</option>
						<utl:selected var="sel" name="Operator" value="LT" index="${i.index}" />
						<option value="${sel}">&lt;</option>
						<utl:selected var="sel" name="Operator" value="GT" index="${i.index}" />
						<option value="${sel}">&gt;</option>
						<utl:selected var="sel" name="Operator" value="LE" index="${i.index}" />
						<option value="${sel}">&lt;=</option>
						<utl:selected var="sel" name="Operator" value="GE" index="${i.index}" />
						<option value="${sel}">&gt;=</option>
						<utl:selected var="sel" name="Operator" value="IN" index="${i.index}" />
						<option value="${sel}">IN</option>
						<utl:selected var="sel" name="Operator" value="LK" index="${i.index}" />
						<option value="${sel}">LIKE</option>
					</select>
				</td>
				<td>
					<input type="text" name="Condition" value="${array.Condition[i.index]}" maxlength="100" size="16" />
				</td>
			<c:if test="${sts.last}">
				<c:out value="</tr>" escapeXml="false" />
				<c:out value="</tbody>" escapeXml="false" />
			</c:if>
			</c:forEach>
			</table>
		</div>

		<div>
			<label for="userPatternName">登録パターン名:</label>
			<input type="text" name="UserPatternName" maxlength="40" value="${UserPatternName}" />
		</div>
		</c:if>
		</form>
	</section>

	<aside>
	</aside>
	<footer style="${AID eq 'search' ? '' : 'display:none'}">
		<c:if test="${fn:length(array.ItemValue) gt 0}">
		<button type="button" class="test">テスト</button>
		<c:if test="${fn:contains(REQUEST_QUERY, 'Id=')}">
		<button type="button" class="delptn">削除</button>
		</c:if>
		<button type="button" class="register">登録</button>
		</c:if>
	</footer>
</main>
<footer>
	<nav>
	</nav>
	<section>
	</section>
</footer>

<table style="display:none">
<tbody>
	<tr id="row1">
		<th colspan="2" class="center">
			<button type="button" class="delcol" >削除</button>
		</th>
		<td class="center">
			<button type="button" class="remove">削除</button>
		</td>
	</tr>
	<tr id="row2">
		<td class="center">
			<select name="Operator">
				<option></option>
				<option value="EQ">=</option>
				<option value="NE">!=</option>
				<option value="LT">&lt;</option>
				<option value="GT">&gt;</option>
				<option value="LE">&lt;=</option>
				<option value="GE">&gt;=</option>
				<option value="IN">IN</option>
				<option value="LK">LIKE</option>
			</select>
		</td>
		<td>
			<input type="text" name="Condition" maxlength="100" size="16" />
		</td>
	</tr>
</tbody>
</table>

<script src="view/js/jquery.min.js"></script>
<script src="view/js/jquery.tablednd.js"></script>
<script src="view/js/submit.js"></script>
<script src="view/js/csv/extract.js"></script>
</body>
</html>
