<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8" />
<title>バッチ状況明細照会</title>
<link rel="stylesheet" href="${CONTEXT}/view/css/import.css" />
</head>

<body>
<header>
	<nav>
		<ul>
			<li><a href="menu.do">メニュー</a></li>
			<li><a href="logoff.do">ログオフ</a></li>
		</ul>
	</nav>
	<section>
		<utl:param var="prm" name="JobSeq" value="" />
		<a href="${STATUS_PATH}?${prm}">状況照会</a> &gt;
	</section>
</header>
<main>
	<header>
		<h3>バッチ詳細状況</h3>
		<div id="topMessage">${MESSAGE}</div>
	</header>
	<section>
		<div>
			<a href="${ACTION_PATH}?${REQUEST_QUERY}">再表示</a>
		</div>
		<div>
			${empty Cnt ? '0' : Cnt} 件
		</div>
		<div>
			<table class="fixborder" >
			<thead>
				<tr>
					<th rowspan="2">No</th>
					<th>バッチ名</th>
					<th>開始日時</th>
					<th>終了日時</th>
					<th rowspan="2" class="center">処理状況</th>
				</tr>
				<tr>
					<th colspan="3" class="center">ファイル(サイズ)</th>
				</tr>
			</thead>
			<c:forEach begin="0" items="${band.BatName}" var="bind" varStatus="st1">
			<tbody>
				<tr>
					<td rowspan="2" class="center">
						${st1.count}
					</td>
					<td class="center">
						<c:set var="val" value="${empty bind.BatName ? '-' : bind.BatName}" />
						${val}
					</td>
					<td class="center">
						${view:datefmt(bind.StartDateTime, 'yyyy/MM/dd hh:mm')}
					</td>
					<td class="center">
						${view:datefmt(bind.StopDateTime, 'yyyy/MM/dd hh:mm')}
					</td>
					<td rowspan="2" class="left">
						<tags:state var="val" value="${bind.Status}" />
						${val}
					</td>
				</tr>
				<tr>
					<td colspan="3" class="center">
					<c:set var="files" value="-" />
					<c:if test="${fn:startsWith(bind.Status, '4')}">
					<c:forEach begin="1" end="5" varStatus="st2">
						<utl:set var="fseq" name="array.FileSeq${st2.index}" />
						<c:if test="${not empty fseq[st1.index]}">
							<c:set var="files" value="" />

							<utl:set var="fmei" name="array.FileName${st2.index}" />
							<utl:encode var="fenc" value="${fmei[st1.index]}" encoding="UTF-8" />

							<a href="DOWNLOAD/JobSeq/${JobSeq}/FileSeq/${fseq[st1.index]}/${fenc}">
							<utl:set var="fsize" name="array.FileSize${st2.index}" />
							${fmei[st1.index]} (${view:numfmt((fsize[st1.index] gt 1000) ? (fsize[st1.index] div 1000) : 1, '0')}KB)
							</a>
							<br />
						</c:if>
					</c:forEach>
					</c:if>
					<c:out value="${files}" />
					</td>
				</tr>
			</tbody>
			</c:forEach>
			</table>
		</div>
	</section>
	<aside>
	</aside>
	<footer>
	</footer>
</main>
<footer>
	<nav>
	</nav>
	<section>
	</section>
</footer>

</body>
</html>
