package project.web.generic;

import online.context.check.InputCheck;
import online.filter.FilterUtil;
import online.struts.action.BaseAction;
import online.struts.action.UniForm;
import project.check.range.LengthRangeCheck;
import project.svc.generic.QueryService;
import project.web.InstanceFactory;

/**
 * 汎用照会画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class SearchAction extends BaseAction {

	/** クエリ */
	private String query = null;

	/**
	 * クエリ設定
	 *
	 * @param qry クエリファイル
	 */
	public final void setQueryFile(final String qry) {
		this.query = qry;
	}

	/**
	 * 表示処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public final String get(final UniForm model) {
		String result = ID_VIEW;
		if (model.hasQueryString()) {
			// 入力チェック
			checkInput(model);

			//DB情報取得
			QueryService ql = InstanceFactory.create(QueryService.class, model);

			String[] files = this.query.split(",");
			for (int i = 0; i < files.length; i++) {
				ql.setQueryFile(files[i]);
				boolean ret = ql.search();
				if (!ret && i == 0) {
					result = "NOT_FOUND";
					break;
				}
			}
			model.putAll(ql.getResultModel());
		}

		return result;
	}

	/**
	 * 入力チェック
	 *
	 * @param model 汎用モデル
	 */
	private void checkInput(final UniForm model) {
		InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		FilterUtil.toParameterKeySet(model.getQueryString()).stream().
				forEach(k -> ic.add(k, new LengthRangeCheck(0, 1024)));
		ic.populate();
	}
}
