package project.web.generic.master;

import online.annotation.SessionEntry;
import online.annotation.SessionExit;
import online.annotation.SessionReserved;
import online.context.check.InputCheck;
import online.struts.action.BaseAction;
import online.struts.action.UniForm;
import project.check.attribute.LongNumeralCheck;
import project.check.attribute.NumeralCheck;
import project.check.existence.MustCheck;
import project.master.MsgUtil;
import project.svc.generic.db.RecordOperate;
import project.web.InstanceFactory;

/**
 * 汎用削除画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
@SessionEntry
public final class ConfirmDeleteAction extends BaseAction {

	/** キー項目 */
	@SessionReserved
	private static final String ID = "Id";
	/** キー項目 */
	private static final String VERSION = "Version";

	/**
	 * 初期表示処理
	 *
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String get(final UniForm model) {
		// 入力チェック
		InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(ID, new MustCheck(), new LongNumeralCheck());
		ic.populate();

		// TODO 権限確認
		RecordOperate ro = InstanceFactory.create(RecordOperate.class, model);
		if (!ro.find(model.getNumber(ID), model)) {
			MsgUtil.putTopMessage(model, "ZZ000000018");
			return ID_NG;
		}

		return ID_VIEW;
	}

	/**
	 * 削除処理
	 *
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	@SessionExit
	public String commit(final UniForm model) {

		// 入力チェック
		if (!model.hasValue(ID)) {
			InputCheck ic = InstanceFactory.create(InputCheck.class, model);
			ic.add(ID, new MustCheck(), new LongNumeralCheck());
			ic.add(VERSION, new MustCheck(), new NumeralCheck());
			ic.populate();
		}

		RecordOperate ro = InstanceFactory.create(RecordOperate.class, model);
		if (!ro.delete(model.getNumber(ID), model.getNumber(VERSION))) {
			// レコード不在
			MsgUtil.putTopMessage(model, "ZZ000000017");
			return ID_NG;
		}

		return ID_OK;
	}
}
