package project.web.plugin;

import javax.servlet.ServletException;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

import project.common.master.Msg;
import project.master.CodeKeeper;

import common.master.IntervalTimer;

import core.config.Factory;

/**
 * プラグインクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class InitialPlugIn implements PlugIn {

	/**
	 * 初期処理
	 *
	 * @param servlet サーブレット
	 * @param config 設定
	 * @throws ServletException サーブレット例外
	 */
	@Override
	public void init(final ActionServlet servlet,
					final ModuleConfig config) throws ServletException {
		//		AppConfig ac = Factory.instantiate(AppConfig.class);
		//		ac.initialize();
		//		IntervalTimer.start(ac, 24d);

		Msg msg = Factory.create(Msg.class);
		msg.initialize();
		IntervalTimer.start(msg, 5);

		CodeKeeper ck = Factory.create(CodeKeeper.class);
		ck.initialize();
		IntervalTimer.start(ck, 24d);
	}

	/**
	 * 最終処理
	 *
	 */
	@Override
	public void destroy() {
		IntervalTimer.stop();
	}
}
