package core.util;

import java.math.BigDecimal;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestNumberUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestNumberUtil.class.getName());
	}

	@Test
	public void 数値オブジェクトBigDecimal変換() {
		Assert.assertEquals(new BigDecimal("123"), NumberUtil.toNumber("123", BigDecimal.class));
	}

	@Test
	public void 数値オブジェクトInteger変換() {
		Assert.assertEquals(Integer.valueOf("1234"), NumberUtil.toNumber("1,234", Integer.class));
	}

	@Test
	public void 数値オブジェクトInteger変換不可() {
		Assert.assertNull(NumberUtil.toNumber("123AB", Integer.class));
	}

	@Test
	public void 数値オブジェクト掛算nullONE() {
		Assert.assertNull(NumberUtil.multiply(null, BigDecimal.ONE));
	}

	@Test
	public void 数値オブジェクト掛算ONEnull() {
		Assert.assertNull(NumberUtil.multiply(BigDecimal.ONE, null));
	}

	@Test
	public void 数値オブジェクト掛算nullnull() {
		Assert.assertNull(NumberUtil.multiply(null, null));
	}

	@Test
	public void 数値オブジェクト掛算nullnullZERO() {
		Assert.assertNull(NumberUtil.multiply(null, null, BigDecimal.ZERO));
	}

	@Test
	public void 数値オブジェクト掛算onenullTEN() {
		Assert.assertEquals(BigDecimal.TEN, NumberUtil.multiply(BigDecimal.ONE, null, BigDecimal.TEN));
	}
}
