package online.model;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestModelUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestModelUtil.class.getName());
	}

	@Test
	public void setBeanItemValueTest1() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("String")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("String")));
		Assert.assertEquals("", um.getString("String"));
		Assert.assertEquals(0, um.getArraySize("String"));
		Assert.assertEquals(0, um.getStringArray("String").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("String")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("StringArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("StringArray")));
		Assert.assertEquals("", um.getString("StringArray"));
		Assert.assertEquals(0, um.getArraySize("StringArray"));
		Assert.assertEquals(0, um.getStringArray("StringArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("StringArray")));
	}

	@Test
	public void setBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray(new String[]{"AAAAA"});
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("String")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("String")));
		Assert.assertEquals("AAAAA", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("String")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("StringArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("StringArray")));
		Assert.assertEquals("AAAAA", um.getString("StringArray"));
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("StringArray")));
	}


	@Test
	public void addBeanItemValueTest1() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("String")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("String")));
		Assert.assertEquals("", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("String")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("StringArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("StringArray")));
		Assert.assertEquals(null, um.getStringArray("StringArray")[0]);
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("StringArray")));
	}

	@Test
	public void addBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray(new String[]{"AAAAA"});
		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("String")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("String")));
		Assert.assertEquals("AAAAA", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("String")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("StringArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("StringArray")));
		Assert.assertEquals("AAAAA", um.getStringArray("StringArray")[0]);
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("StringArray")));
	}


	@Test
	public void setModelValueTest1() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest2() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", "AAAAA");
		um.setValue("StringArray", new String[]{"AAAAA"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("AAAAA", bean.getString());
		Assert.assertEquals("AAAAA", bean.getStringArray()[0]);
	}

	@Test
	public void setModelValueTest3() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", new String[]{"ZZZZ", "TRUE"});
		um.setValue("BooleanArray", new String[]{"ZZZZ", "TRUE"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[0]));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[1]));
		Assert.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assert.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	@Test
	public void setModelValueTest4() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", new String[]{"111", "222"});
		um.setValue("IntegerArray", new String[]{"333", "444"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(111, bean.getPrimitiveIntegerArray()[0]);
		Assert.assertEquals(222, bean.getPrimitiveIntegerArray()[1]);
		Assert.assertEquals(Integer.valueOf(333), bean.getIntegerArray()[0]);
		Assert.assertEquals(Integer.valueOf(444), bean.getIntegerArray()[1]);
	}

	@Test
	public void setModelValueTest5() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	@Test
	public void setModelValueTest6() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	@Test
	public void setModelValueTest7() {
		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String)null);

		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(1, bean.getStringArray().length);
		Assert.assertNull(bean.getStringArray()[0]);
	}

	@Test
	public void setModelValueTest8() {
		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", "aaaa");
		um.setValue("StringArray", "bbbb");

		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("aaaa", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(1, bean.getStringArray().length);
		Assert.assertEquals("bbbb", bean.getStringArray()[0]);
	}


	@Test
	public void setModelValueTest10() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest11() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new String[]{"ZZZZ", "AAAAA"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals("AAAAA", bean.getString());
	}

	@Test
	public void setModelValueTest12() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new String[]{"ZZZZ", "TRUE"});
		um.setValue("Boolean", new String[]{"ZZZZ", "TRUE"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
	}

	@Test
	public void setModelValueTest13() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new String[]{"1111", "2,222"});
		um.setValue("Integer", new String[]{"3333", "4444"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(2222, bean.getPrimitiveInteger());
		Assert.assertEquals(Integer.valueOf(4444), bean.getInteger());
	}

	@Test
	public void setModelValueTest14() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new String[]{"1111", ",,"});
		um.setValue("Integer", new String[]{"3333", ","});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getInteger());
	}

	@Test
	public void setModelValueTest15() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	@Test
	public void setModelValueTest16() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	@Test
	public void setModelValueTest20() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest21() {
		JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());

		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest31() {
		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new String[]{"aaaa", "bbbb"});
		um.setValue("StringArray", new String[]{"aaaa", "bbbb"});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals("aaaa", bean.getStringArray()[0]);
		Assert.assertEquals("bbbb", bean.getStringArray()[1]);
	}
}
