package online.model;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestModelUtilBoolean {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestModelUtilBoolean.class.getName());
	}

	@Test
	public void setBeanItemValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveBoolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("PrimitiveBooleanArray")));
		Assert.assertEquals(null, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(0, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(0, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveBooleanArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Boolean")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("Boolean")));
		Assert.assertEquals(null, um.getBoolean("Boolean"));
		Assert.assertEquals(0, um.getArraySize("Boolean"));
		Assert.assertEquals(0, um.getBooleanArray("Boolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Boolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BooleanArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("BooleanArray")));
		Assert.assertEquals(null, um.getBoolean("BooleanArray"));
		Assert.assertEquals(0, um.getArraySize("BooleanArray"));
		Assert.assertEquals(0, um.getBooleanArray("BooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("BooleanArray")));
	}

	@Test
	public void setBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveBoolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveBooleanArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Boolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Boolean")));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Boolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("BooleanArray")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assert.assertEquals(2, um.getArraySize("BooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("BooleanArray")));
	}


	@Test
	public void addBeanItemValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveBoolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBooleanArray")));
		Assert.assertEquals(null, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveBooleanArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Boolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Boolean")));
		Assert.assertEquals(null, um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Boolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("BooleanArray")));
		Assert.assertEquals(null, um.getBoolean("BooleanArray"));
		Assert.assertEquals(1, um.getArraySize("BooleanArray"));
		Assert.assertEquals(1, um.getBooleanArray("BooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("BooleanArray")));
	}

	@Test
	public void addBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBoolean")));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveBoolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveBooleanArray")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveBooleanArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Boolean")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Boolean")));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Boolean")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BooleanArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("BooleanArray")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assert.assertEquals(2, um.getArraySize("BooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("BooleanArray")));
	}


	@Test
	public void setModelValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBoolean());
		Assert.assertNull(bean.isBooleanArray());
	}

	@Test
	public void setModelValueTest2() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", Boolean.TRUE);
		um.setValue("PrimitiveBooleanArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("Boolean", Boolean.TRUE);
		um.setValue("BooleanArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[0]));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[1]));
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assert.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assert.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	@Test
	public void setModelValueTest3() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("StringArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("false", bean.getString());
		Assert.assertEquals("false", bean.getStringArray()[0]);
		Assert.assertEquals("true", bean.getStringArray()[1]);
	}


	@Test
	public void setModelValueTest10() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBoolean());
		Assert.assertNull(bean.isBooleanArray());
	}

	@Test
	public void setModelValueTest11() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("Boolean", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
	}

	@Test
	public void setModelValueTest12() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals("true", bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest31() {
		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("StringArray", new Boolean[]{Boolean.TRUE, Boolean.FALSE});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals("true", bean.getStringArray()[0]);
		Assert.assertEquals("false", bean.getStringArray()[1]);
	}
}
