package online.model;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestModelUtilNumber {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestModelUtilNumber.class.getName());
	}

	@Test
	public void setBeanItemValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.setBeanItemValue(um, bean, "Integer");
		ModelUtil.setBeanItemValue(um, bean, "IntegerArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveInteger")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveInteger")));
		Assert.assertEquals(Integer.valueOf(0), um.getNumber("PrimitiveInteger"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assert.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveInteger")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveIntegerArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("PrimitiveIntegerArray")));
		Assert.assertNull(um.getNumber("PrimitiveIntegerArray"));
		Assert.assertEquals(0, um.getArraySize("PrimitiveIntegerArray"));
		Assert.assertEquals(0, um.getNumberArray("PrimitiveIntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveIntegerArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Integer")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("Integer")));
		Assert.assertNull(um.getNumber("Integer"));
		Assert.assertEquals(0, um.getArraySize("Integer"));
		Assert.assertEquals(0, um.getNumberArray("Integer").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Integer")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("IntegerArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("IntegerArray")));
		Assert.assertNull(um.getNumber("IntegerArray"));
		Assert.assertEquals(0, um.getArraySize("IntegerArray"));
		Assert.assertEquals(0, um.getNumberArray("IntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("IntegerArray")));
	}

	@Test
	public void setBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setPrimitiveInteger(100);
		bean.setPrimitiveIntegerArray(new int[]{111, 999});
		bean.setInteger(Integer.valueOf(200));
		bean.setIntegerArray(new Integer[]{Integer.valueOf(222), Integer.valueOf(888)});

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.setBeanItemValue(um, bean, "Integer");
		ModelUtil.setBeanItemValue(um, bean, "IntegerArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveInteger")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveInteger")));
		Assert.assertEquals(Integer.valueOf(100), um.getNumber("PrimitiveInteger"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assert.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveInteger")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveIntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveIntegerArray")));
		Assert.assertEquals(Integer.valueOf(111), um.getNumber("PrimitiveIntegerArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveIntegerArray"));
		Assert.assertEquals(2, um.getNumberArray("PrimitiveIntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveIntegerArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Integer")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Integer")));
		Assert.assertEquals(Integer.valueOf(200), um.getNumber("Integer"));
		Assert.assertEquals(1, um.getArraySize("Integer"));
		Assert.assertEquals(1, um.getNumberArray("Integer").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Integer")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("IntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("IntegerArray")));
		Assert.assertEquals(Integer.valueOf(222), um.getNumber("IntegerArray"));
		Assert.assertEquals(2, um.getArraySize("IntegerArray"));
		Assert.assertEquals(2, um.getNumberArray("IntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("IntegerArray")));
	}


	@Test
	public void addBeanItemValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.addBeanItemValue(um, bean, "Integer");
		ModelUtil.addBeanItemValue(um, bean, "IntegerArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveInteger")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveInteger")));
		Assert.assertEquals(Integer.valueOf(0), um.getNumber("PrimitiveInteger"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assert.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveInteger")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveIntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveIntegerArray")));
		Assert.assertNull(um.getNumber("PrimitiveIntegerArray"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveIntegerArray"));
		Assert.assertEquals(1, um.getNumberArray("PrimitiveIntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveIntegerArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Integer")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Integer")));
		Assert.assertNull(um.getNumber("Integer"));
		Assert.assertEquals(1, um.getArraySize("Integer"));
		Assert.assertEquals(1, um.getNumberArray("Integer").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Integer")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("IntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("IntegerArray")));
		Assert.assertNull(um.getNumber("IntegerArray"));
		Assert.assertEquals(1, um.getArraySize("IntegerArray"));
		Assert.assertEquals(1, um.getNumberArray("IntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("IntegerArray")));
	}

	@Test
	public void addBeanItemValueTest2() {
		JavaBean bean = new JavaBean();
		bean.setPrimitiveInteger(100);
		bean.setPrimitiveIntegerArray(new int[]{111, 999});
		bean.setInteger(Integer.valueOf(200));
		bean.setIntegerArray(new Integer[]{Integer.valueOf(222), Integer.valueOf(888)});

		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.addBeanItemValue(um, bean, "Integer");
		ModelUtil.addBeanItemValue(um, bean, "IntegerArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveInteger")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveInteger")));
		Assert.assertEquals(Integer.valueOf(100), um.getNumber("PrimitiveInteger"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assert.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("PrimitiveInteger")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("PrimitiveIntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("PrimitiveIntegerArray")));
		Assert.assertEquals(Integer.valueOf(111), um.getNumber("PrimitiveIntegerArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveIntegerArray"));
		Assert.assertEquals(2, um.getNumberArray("PrimitiveIntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("PrimitiveIntegerArray")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Integer")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Integer")));
		Assert.assertEquals(Integer.valueOf(200), um.getNumber("Integer"));
		Assert.assertEquals(1, um.getArraySize("Integer"));
		Assert.assertEquals(1, um.getNumberArray("Integer").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Integer")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("IntegerArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("IntegerArray")));
		Assert.assertEquals(Integer.valueOf(222), um.getNumber("IntegerArray"));
		Assert.assertEquals(2, um.getArraySize("IntegerArray"));
		Assert.assertEquals(2, um.getNumberArray("IntegerArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("IntegerArray")));
	}


	@Test
	public void setModelValueTest1() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getInteger());
		Assert.assertNull(bean.getIntegerArray());
	}

	@Test
	public void setModelValueTest2() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", Integer.valueOf(100));
		um.setValue("PrimitiveIntegerArray", new Integer[]{Integer.valueOf(222), Integer.valueOf(333)});
		um.setValue("Integer", Integer.valueOf(444));
		um.setValue("IntegerArray", new Integer[]{Integer.valueOf(555), Integer.valueOf(666)});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(100, bean.getPrimitiveInteger());
		Assert.assertEquals(222, bean.getPrimitiveIntegerArray()[0]);
		Assert.assertEquals(333, bean.getPrimitiveIntegerArray()[1]);
		Assert.assertEquals(Integer.valueOf(444), bean.getInteger());
		Assert.assertEquals(Integer.valueOf(555), bean.getIntegerArray()[0]);
		Assert.assertEquals(Integer.valueOf(666), bean.getIntegerArray()[1]);
	}

	@Test
	public void setModelValueTest3() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Integer[]{Integer.valueOf(100), Integer.valueOf(200)});
		um.setValue("StringArray", new Integer[]{Integer.valueOf(300), Integer.valueOf(400)});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("100", bean.getString());
		Assert.assertEquals("300", bean.getStringArray()[0]);
		Assert.assertEquals("400", bean.getStringArray()[1]);
	}

	@Test
	public void setModelValueTest4() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", Integer.valueOf(1000));
		um.setValue("StringArray", new Integer[]{Integer.valueOf(300), Integer.valueOf(400)});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("1000", bean.getString());
		Assert.assertEquals("300", bean.getStringArray()[0]);
		Assert.assertEquals("400", bean.getStringArray()[1]);
	}


	@Test
	public void setModelValueTest10() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getInteger());
		Assert.assertNull(bean.getIntegerArray());
	}

	@Test
	public void setModelValueTest11() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new Integer[]{Integer.valueOf(111), Integer.valueOf(222)});
		um.setValue("Integer", new Integer[]{Integer.valueOf(333), Integer.valueOf(444)});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(222, bean.getPrimitiveInteger());
		Assert.assertEquals(Integer.valueOf(444), bean.getInteger());
		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
	}

	@Test
	public void setModelValueTest12() {
		JavaBean bean = new JavaBean();

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Integer[]{Integer.valueOf(111), Integer.valueOf(222)});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals("222", bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	@Test
	public void setModelValueTest31() {
		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Integer[]{Integer.valueOf(11), Integer.valueOf(22)});
		um.setValue("StringArray", new Integer[]{Integer.valueOf(33), Integer.valueOf(44)});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals("33", bean.getStringArray()[0]);
		Assert.assertEquals("44", bean.getStringArray()[1]);
	}
}
