package project.filter.helper;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * IE用xhtmlレスポンスラッパ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class IEXhtmlResponseWrapper extends HttpServletResponseWrapper {
	/** コンテントタイプ */
	private String contentType;

	/**
	 * コンストラクタ
	 * @param response HttpServletResponse
	 */
	public IEXhtmlResponseWrapper(final HttpServletResponse response) {
		super(response);
	}

	/**
	 * @see javax.servlet.ServletResponse#setContentType(java.lang.String)
	 */
	@Override
	public void setContentType(final String type) {
		String target = "application/xhtml+xml";
		if (type.startsWith(target)) {
			super.setContentType("text/html" + type.substring(target.length()));
		} else {
			super.setContentType(type);
		}
		this.contentType = type;
	}

	/**
	 * @see javax.servlet.ServletResponse#getContentType()
	 */
	@Override
	public String getContentType() {
		return this.contentType;
	}
}
